/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.settings;

import java.io.IOException;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OfflineSettings
extends SimpleIQ {
    private String redirectURL;
    private String offlineText;
    private String emailAddress;
    private String subject;
    public static final String ELEMENT_NAME = "offline-settings";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public String getRedirectURL() {
        if (!StringUtils.isNotEmpty((CharSequence)this.redirectURL)) {
            return "";
        }
        return this.redirectURL;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public String getOfflineText() {
        if (!StringUtils.isNotEmpty((CharSequence)this.offlineText)) {
            return "";
        }
        return this.offlineText;
    }

    public void setOfflineText(String offlineText) {
        this.offlineText = offlineText;
    }

    public String getEmailAddress() {
        if (!StringUtils.isNotEmpty((CharSequence)this.emailAddress)) {
            return "";
        }
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getSubject() {
        if (!StringUtils.isNotEmpty((CharSequence)this.subject)) {
            return "";
        }
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean redirects() {
        return StringUtils.isNotEmpty((CharSequence)this.getRedirectURL());
    }

    public boolean isConfigured() {
        return StringUtils.isNotEmpty((CharSequence)this.getEmailAddress()) && StringUtils.isNotEmpty((CharSequence)this.getSubject()) && StringUtils.isNotEmpty((CharSequence)this.getOfflineText());
    }

    public OfflineSettings() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public static class InternalProvider
    extends IQProvider<OfflineSettings> {
        public OfflineSettings parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            OfflineSettings offlineSettings = new OfflineSettings();
            boolean done = false;
            String redirectPage = null;
            String subject = null;
            String offlineText = null;
            String emailAddress = null;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && "redirectPage".equals(parser.getName())) {
                    redirectPage = parser.nextText();
                    continue;
                }
                if (eventType == 2 && "subject".equals(parser.getName())) {
                    subject = parser.nextText();
                    continue;
                }
                if (eventType == 2 && "offlineText".equals(parser.getName())) {
                    offlineText = parser.nextText();
                    continue;
                }
                if (eventType == 2 && "emailAddress".equals(parser.getName())) {
                    emailAddress = parser.nextText();
                    continue;
                }
                if (eventType != 3 || !OfflineSettings.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            offlineSettings.setEmailAddress(emailAddress);
            offlineSettings.setRedirectURL(redirectPage);
            offlineSettings.setSubject(subject);
            offlineSettings.setOfflineText(offlineText);
            return offlineSettings;
        }
    }
}

