/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.logging;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.naming.NamingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    public static final Log CONFIG = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONFIG");
    public static final Log PERSISTENCE = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.PERSISTENCE");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception while marshalling object: %s", id=65)
    public void errorMarshallingObject(@Cause Throwable var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed clearing cache store", id=8001)
    public void failedClearingJdbcCacheStore(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="SQL failure while integrating state into store", id=8003)
    public void sqlFailureIntegratingState(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="I/O error while unmarshalling from stream", id=8009)
    public void ioErrorUnmarshalling(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="*UNEXPECTED* ClassNotFoundException.", id=8010)
    public void unexpectedClassNotFoundException(@Cause ClassNotFoundException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while creating table; used DDL statement: '%s'", id=8011)
    public void errorCreatingTable(String var1, @Cause SQLException var2);

    @Message(value="Could not find a connection in %s under the name '%s'", id=8015)
    public IllegalStateException connectionNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not lookup connection with datasource %s", id=8016)
    public void namingExceptionLookingUpConnection(String var1, @Cause NamingException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to close naming context.", id=8017)
    public void failedClosingNamingCtx(@Cause NamingException var1);

    @Message(value="Sql failure retrieving connection from datasource", id=8018)
    public PersistenceException sqlFailureRetrievingConnection(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Issues while closing connection %s", id=8019)
    public void sqlFailureClosingConnection(Connection var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected sql failure", id=8022)
    public void sqlFailureUnexpected(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failure while closing the connection to the database", id=8023)
    public void failureClosingConnection(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while storing string key to database; key: '%s'", id=8024)
    public void sqlFailureStoringKey(Object var1, @Cause SQLException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while removing string keys from database", id=8025)
    public void sqlFailureRemovingKeys(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="In order for JdbcStringBasedStore to support %s, the Key2StringMapper needs to implement TwoWayKey2StringMapper. You should either make %s implement TwoWayKey2StringMapper or disable the sql. See [https://jira.jboss.org/browse/ISPN-579] for more details.", id=8026)
    public void invalidKey2StringMapper(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="SQL error while fetching stored entry with key: %s, lockingKey: %s", id=8027)
    public void sqlFailureReadingKey(Object var1, Object var2, @Cause SQLException var3);

    @Message(value="Attribute '%2$s' has not been set on '%1$s'", id=8028)
    public CacheConfigurationException tableManipulationAttributeNotSet(String var1, String var2);

    @Message(value="A ConnectionFactory has not been specified for this store", id=8029)
    public CacheConfigurationException missingConnectionFactory();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error committing JDBC transaction", id=8031)
    public void sqlFailureTxCommit(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error during rollback of JDBC transaction", id=8032)
    public void sqlFailureTxRollback(@Cause SQLException var1);

    @Message(value="Exception encountered when preparing JDBC store Tx", id=8033)
    public PersistenceException prepareTxFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to notify the PurgeListener of expired cache entries as the configured key2StringMapper does not implement %s", id=8036)
    public void twoWayKey2StringMapperIsMissing(String var1);

    @Message(value="Error while writing entries in batch to the database:", id=8037)
    public PersistenceException sqlFailureWritingBatch(@Cause Throwable var1);

    @Message(value="The existing store was created without segmentation enabled", id=8039)
    public CacheConfigurationException existingStoreNoSegmentation();

    @Message(value="The existing store was created with %d segments configured, but the cache is configured with %d", id=8040)
    public CacheConfigurationException existingStoreSegmentMismatch(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error retrieving JDBC metadata", id=8041)
    public void sqlFailureMetaRetrieval(@Cause SQLException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="SQL failure while retrieving size", id=8042)
    public void sqlFailureSize(@Cause SQLException var1);

    @Message(value="Primary key has multiple columns but no key message schema defined, which is required when there is more than one key column", id=8043)
    public CacheConfigurationException primaryKeyMultipleColumnWithoutSchema();

    @Message(value="Multiple non key columns but no value message schema defined, which is required when there is more than one value column", id=8044)
    public CacheConfigurationException valueMultipleColumnWithoutSchema();

    @Message(value="Primary key %s was not found in the key schema %s", id=8045)
    public CacheConfigurationException keyNotInSchema(String var1, String var2);

    @Message(value="Additional value columns %s found that were not part of the schema, make sure the columns returned match the value schema %s", id=8046)
    public CacheConfigurationException valueNotInSchema(List<String> var1, String var2);

    @Message(value="Schema not found for : %s", id=8047)
    public CacheConfigurationException schemaNotFound(String var1);

    @Message(value="Key cannot be embedded when the value schema %s is an enum", id=8048)
    public CacheConfigurationException keyCannotEmbedWithEnum(String var1);

    @Message(value="Repeated fields are not supported, found %s in schema %s", id=8049)
    public CacheConfigurationException repeatedFieldsNotSupported(String var1, String var2);

    @Message(value="Duplicate name %s found for nested schema: %s", id=8050)
    public CacheConfigurationException duplicateFieldInSchema(String var1, String var2);

    @Message(value="Schema contained a field %s that is required but wasn't found in the query for schema %s", id=8051)
    public CacheConfigurationException requiredSchemaFieldNotPresent(String var1, String var2);

    @Message(value="Primary key %s was found in the value schema %s but embedded key was not true", id=8052)
    public CacheConfigurationException primaryKeyPresentButNotEmbedded(String var1, String var2);

    @Message(value="Delete and select queries do not have matching arguments. Delete was %s and select was %s", id=8053)
    public CacheConfigurationException deleteAndSelectQueryMismatchArguments(List<String> var1, List<String> var2);

    @Message(value="Named parameter %s in upsert statement [%s] is not available in columns from selectAll statement [%s]", id=8054)
    public CacheConfigurationException deleteAndSelectQueryMismatchArguments(String var1, String var2, String var3);

    @Message(value="No parameters are allowed for select all statement %s", id=8055)
    public CacheConfigurationException selectAllCannotHaveParameters(String var1);

    @Message(value="No parameters are allowed for delete all statement %s", id=8056)
    public CacheConfigurationException deleteAllCannotHaveParameters(String var1);

    @Message(value="No parameters are allowed for sizer statement %s", id=8057)
    public CacheConfigurationException sizeCannotHaveParameters(String var1);

    @Message(value="Not all key columns %s were returned from select all statement %s", id=8058)
    public CacheConfigurationException keyColumnsNotReturnedFromSelectAll(String var1, String var2);

    @Message(value="Select parameter %s is not returned from select all statement %s, select statement is %s", id=8059)
    public CacheConfigurationException namedParamNotReturnedFromSelect(String var1, String var2, String var3);

    @Message(value="Non-terminated named parameter declaration at position %d in statement: %s", id=8060)
    public CacheConfigurationException nonTerminatedNamedParamInSql(int var1, String var2);

    @Message(value="Invalid character %s at position %d in statement: %s", id=8061)
    public CacheConfigurationException invalidCharacterInSql(char var1, int var2, String var3);

    @Message(value="Unnamed parameters are not allowed, found one at %d in statement %s", id=8062)
    public CacheConfigurationException unnamedParametersNotAllowed(int var1, String var2);

    @Message(value="Provided table name %s is not in form of (<SCHEMA>.)<TABLE-NAME> where SCHEMA is optional", id=8063)
    public CacheConfigurationException tableNotInCorrectFormat(String var1);

    @Message(value="No primary keys found for table %s, check case sensitivity", id=8064)
    public CacheConfigurationException noPrimaryKeysFoundForTable(String var1);

    @Message(value="No column found that wasn't a primary key for table: %s", id=8065)
    public CacheConfigurationException noValueColumnForTable(String var1);

    @Message(value="Unable to detect database dialect from JDBC driver name or connection metadata.  Please provide this manually using the 'dialect' property in your configuration.  Supported database dialect strings are %s", id=8066)
    public CacheConfigurationException unableToDetectDialect(String var1);

    @Message(value="The size, select and select all attributes must be set for a query store", id=8067)
    public CacheConfigurationException requiredStatementsForQueryStoreLoader();

    @Message(value="The delete, delete all and upsert attributes must be set for a query store that allows writes", id=8068)
    public CacheConfigurationException requiredStatementsForQueryStoreWriter();

    @Message(value="Key columns are required for QueryStore", id=8069)
    public CacheConfigurationException keyColumnsRequired();

    @Message(value="Message name must not be null if embedded key is true", id=8070)
    public CacheConfigurationException messageNameRequiredIfEmbeddedKey();

    @Message(value="Table name must be non null", id=8071)
    public CacheConfigurationException tableNameMissing();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="There was no JDBC metadata present in table %s, unable to confirm if segments are properly configured! Segments are assumed to be properly configured.", id=8072)
    public void sqlMetadataNotPresent(String var1);
}

