/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.NoopChannelOperation;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.CSAIntegrationTest")
public class CSAIntegrationTest
extends HitsAwareCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private HotRodServer hotRodServer3;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;
    private ChannelFactory channelFactory;
    private static final Log log = LogFactory.getLog(CSAIntegrationTest.class);

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)CSAIntegrationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numOwners(1);
        builder.unsafe().unreliableReturnValues(true);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        this.addr2hrServer.put(InetSocketAddress.createUnresolved(this.hotRodServer1.getHost(), this.hotRodServer1.getPort()), this.hotRodServer1);
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer(this.manager(1));
        this.addr2hrServer.put(InetSocketAddress.createUnresolved(this.hotRodServer2.getHost(), this.hotRodServer2.getPort()), this.hotRodServer2);
        this.hotRodServer3 = HotRodClientTestingUtil.startHotRodServer(this.manager(2));
        this.addr2hrServer.put(InetSocketAddress.createUnresolved(this.hotRodServer3.getHost(), this.hotRodServer3.getPort()), this.hotRodServer3);
        assert (this.manager(0).getCache() != null);
        assert (this.manager(1).getCache() != null);
        assert (this.manager(2).getCache() != null);
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)3);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(0).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(1).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(2).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServers("localhost:" + this.hotRodServer2.getPort() + ";localhost:" + this.hotRodServer2.getPort());
        this.remoteCacheManager = new InternalRemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.channelFactory = ((InternalRemoteCacheManager)this.remoteCacheManager).getChannelFactory();
    }

    protected void setHotRodProtocolVersion(ConfigurationBuilder clientBuilder) {
    }

    @Override
    @AfterClass
    protected void destroy() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2, this.hotRodServer3);
        super.destroy();
    }

    public void testHashInfoRetrieved() throws InterruptedException {
        AssertJUnit.assertEquals((int)3, (int)this.channelFactory.getServers().size());
        for (int i = 0; i < 10; ++i) {
            this.remoteCache.put((Object)"k", (Object)"v");
            if (this.channelFactory.getServers().size() == 3) break;
            Thread.sleep(1000L);
        }
        AssertJUnit.assertEquals((int)3, (int)this.channelFactory.getServers().size());
        AssertJUnit.assertNotNull((Object)this.channelFactory.getConsistentHash(HotRodConstants.DEFAULT_CACHE_NAME_BYTES));
    }

    @Test(dependsOnMethods={"testHashInfoRetrieved"})
    public void testCorrectSetup() {
        this.remoteCache.put((Object)"k", (Object)"v");
        assert (this.remoteCache.get((Object)"k").equals("v"));
    }

    @Test(dependsOnMethods={"testCorrectSetup"})
    public void testHashFunctionReturnsSameValues() throws InterruptedException {
        for (int i = 0; i < 1000; ++i) {
            byte[] key = this.generateKey(i);
            Channel channel = (Channel)((NoopChannelOperation)this.channelFactory.fetchChannelAndInvoke((Object)key, null, HotRodConstants.DEFAULT_CACHE_NAME_BYTES, (ChannelOperation)new NoopChannelOperation())).join();
            SocketAddress serverAddress = ChannelRecord.of((Channel)channel).getUnresolvedAddress();
            EmbeddedCacheManager cacheContainer = ((HotRodServer)this.addr2hrServer.get(serverAddress)).getCacheManager();
            AssertJUnit.assertNotNull((String)("For server address " + serverAddress + " found " + cacheContainer + ". Map is: " + this.addr2hrServer), (Object)cacheContainer);
            DistributionManager distributionManager = cacheContainer.getCache().getAdvancedCache().getDistributionManager();
            Address clusterAddress = cacheContainer.getCache().getAdvancedCache().getRpcManager().getAddress();
            ConsistentHash serverCh = distributionManager.getReadConsistentHash();
            int numSegments = serverCh.getNumSegments();
            int keySegment = serverCh.getSegment((Object)key);
            Address serverOwner = serverCh.locatePrimaryOwnerForSegment(keySegment);
            Address serverPreviousOwner = serverCh.locatePrimaryOwnerForSegment((keySegment - 1 + numSegments) % numSegments);
            assert (clusterAddress.equals(serverOwner) || clusterAddress.equals(serverPreviousOwner));
            this.channelFactory.releaseChannel(channel);
        }
    }

    @Test(dependsOnMethods={"testHashFunctionReturnsSameValues"})
    public void testRequestsGoToExpectedServer() throws Exception {
        Channel channel;
        String keyStr;
        this.addInterceptors();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (int i = 0; i < 500; ++i) {
            byte[] key = this.generateKey(i);
            keys.add(key);
            keyStr = new String(key);
            this.remoteCache.put((Object)keyStr, (Object)"value");
            channel = (Channel)((NoopChannelOperation)this.channelFactory.fetchChannelAndInvoke((Object)HotRodTestingUtil.marshall((Object)keyStr), null, RemoteCacheManager.cacheNameBytes(), (ChannelOperation)new NoopChannelOperation())).join();
            HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)((HotRodServer)this.addr2hrServer.get(ChannelRecord.of((Channel)channel).getUnresolvedAddress())).getCacheManager(), (String)keyStr, (String)"value");
            this.channelFactory.releaseChannel(channel);
        }
        log.info((Object)"Right before first get.");
        for (byte[] key : keys) {
            this.resetStats();
            keyStr = new String(key);
            assert (this.remoteCache.get((Object)keyStr).equals("value"));
            channel = (Channel)((NoopChannelOperation)this.channelFactory.fetchChannelAndInvoke((Object)HotRodTestingUtil.marshall((Object)keyStr), null, HotRodConstants.DEFAULT_CACHE_NAME_BYTES, (ChannelOperation)new NoopChannelOperation())).join();
            this.assertOnlyServerHit(ChannelRecord.of((Channel)channel).getUnresolvedAddress());
            this.channelFactory.releaseChannel(channel);
        }
    }

    private byte[] generateKey(int i) {
        Random r = new Random();
        byte[] result = new byte[i];
        r.nextBytes(result);
        return result;
    }
}

