/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.function.BiConsumer;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ExecTypedTest")
public class ExecTypedTest
extends MultiHotRodServersTest {
    private static final String SCRIPT_CACHE = "___script_cache";
    private static final int NUM_SERVERS = 2;
    static final String NAME = "exec-typed-cache";
    RemoteCacheManager execClient;
    RemoteCacheManager addScriptClient;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, new org.infinispan.configuration.cache.ConfigurationBuilder());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)ExecTypedTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        this.defineInAll(NAME, builder);
        this.execClient = this.createExecClient();
        this.addScriptClient = this.createAddScriptClient();
    }

    protected ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
    }

    private RemoteCacheManager createExecClient() {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(((HotRodServer)this.servers.get(0)).getPort());
        clientBuilder.marshaller((Marshaller)new UTF8StringMarshaller());
        clientBuilder.version(this.getProtocolVersion());
        return new InternalRemoteCacheManager(clientBuilder.build());
    }

    private RemoteCacheManager createAddScriptClient() {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(((HotRodServer)this.servers.get(0)).getPort());
        clientBuilder.version(this.getProtocolVersion());
        return new InternalRemoteCacheManager(clientBuilder.build());
    }

    public void testLocalTypedExecPutGet() {
        this.execPutGet("/typed-put-get.js", ExecMode.LOCAL, "local-typed-key", "local-typed-value");
    }

    public void testLocalTypedExecPutGetCyrillic() {
        this.execPutGet("/typed-put-get.js", ExecMode.LOCAL, "\u0562\u0561\u0580\u0587", "\u043f\u0440\u0438\u0432\u0435\u0442");
    }

    public void testLocalTypedExecPutGetEmptyString() {
        HotRodClientTestingUtil.withScript((BasicCache<String, String>)this.addScriptClient.getCache(SCRIPT_CACHE), "/typed-put-get.js", scriptName -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("k", "empty-key");
            params.put("v", "");
            String result = (String)this.execClient.getCache(NAME).execute(scriptName, params);
            AssertJUnit.assertEquals(null, (String)result);
        });
    }

    public void testLocalTypedExecSize() {
        HotRodClientTestingUtil.withScript((BasicCache<String, String>)this.addScriptClient.getCache(SCRIPT_CACHE), "/typed-size.js", scriptName -> {
            this.execClient.getCache(NAME).clear();
            String result = (String)this.execClient.getCache(NAME).execute(scriptName, new HashMap());
            AssertJUnit.assertEquals((String)"0", (String)result);
        });
    }

    public void testLocalTypedExecWithCacheManager() {
        HotRodClientTestingUtil.withScript((BasicCache<String, String>)this.addScriptClient.getCache(SCRIPT_CACHE), "/typed-cachemanager-put-get.js", scriptName -> {
            String result = (String)this.execClient.getCache(NAME).execute(scriptName, new HashMap());
            AssertJUnit.assertEquals((String)"a", (String)result);
        });
    }

    public void testLocalTypedExecNullReturn() {
        HotRodClientTestingUtil.withScript((BasicCache<String, String>)this.addScriptClient.getCache(SCRIPT_CACHE), "/typed-null-return.js", scriptName -> {
            String result = (String)this.execClient.getCache(NAME).execute(scriptName, new HashMap());
            AssertJUnit.assertEquals(null, (String)result);
        });
    }

    public void testDistTypedExecNullReturn() {
        HotRodClientTestingUtil.withScript((BasicCache<String, String>)this.addScriptClient.getCache(SCRIPT_CACHE), "/typed-dist-null-return.js", scriptName -> {
            String result = (String)this.execClient.getCache(NAME).execute(scriptName, new HashMap());
            AssertJUnit.assertEquals((String)"[null,null]", (String)result.replaceAll("\\s", ""));
            String resultAsJson = (String)this.execClient.getCache(NAME).withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).build()).execute(scriptName, new HashMap());
            AssertJUnit.assertEquals((String)"[null,null]", (String)resultAsJson.replaceAll("\\s", ""));
        });
    }

    public void testDistTypedExecPutGet() {
        this.execPutGet("/typed-put-get-dist.js", ExecMode.DIST, "dist-typed-key", "dist-typed-value");
    }

    public void testLocalTypedExecPutGetWithListener() {
        EventLogListener l = new EventLogListener(this.execClient.getCache(NAME));
        HotRodClientTestingUtil.withClientListener(l, remote -> HotRodClientTestingUtil.withScript((BasicCache<String, String>)this.addScriptClient.getCache(SCRIPT_CACHE), "/typed-put-get.js", scriptName -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("k", "local-typed-key-listen");
            params.put("v", "local-typed-value-listen");
            String result = (String)remote.execute(scriptName, params);
            l.expectOnlyCreatedEvent("local-typed-key-listen");
            AssertJUnit.assertEquals((String)"local-typed-value-listen", (String)result);
        }));
    }

    private void execPutGet(String path, ExecMode mode, String key, String value) {
        HotRodClientTestingUtil.withScript((BasicCache<String, String>)this.addScriptClient.getCache(SCRIPT_CACHE), path, scriptName -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("k", key);
            params.put("v", value);
            String result = (String)this.execClient.getCache(NAME).execute(scriptName, params);
            mode.assertResult.accept(value, result);
        });
    }

    static enum ExecMode {
        LOCAL(AssertJUnit::assertEquals),
        DIST((v, r) -> AssertJUnit.assertEquals((String)String.format("[\"%1$s\", \"%1$s\"]", v), (String)r));

        final BiConsumer<String, String> assertResult;

        private ExecMode(BiConsumer<String, String> assertResult) {
            this.assertResult = assertResult;
        }
    }
}

