/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.RemoteAsyncAPITest")
public class RemoteAsyncAPITest
extends SingleHotRodServerTest {
    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.forceReturnValues(this.isForceReturnValuesViaConfiguration());
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        return new InternalRemoteCacheManager(builder.build());
    }

    protected boolean isForceReturnValuesViaConfiguration() {
        return true;
    }

    protected RemoteCache<String, String> remote() {
        return this.remoteCacheManager.getCache();
    }

    public void testPutAsync() throws Exception {
        CompletableFuture f = this.remote().putAsync((Object)"k", (Object)"v");
        this.testFuture(f, null);
        this.testK("v");
        f = this.remote().putAsync((Object)"k", (Object)"v2");
        this.testFuture(f, "v");
        this.testK("v2");
    }

    public void testPutAsyncWithListener() throws Exception {
        CompletableFuture f = this.remote().putAsync((Object)"k", (Object)"v");
        this.testFutureWithListener(f, null);
        this.testK("v");
        f = this.remote().putAsync((Object)"k", (Object)"v2");
        this.testFutureWithListener(f, "v");
        this.testK("v2");
    }

    public void testPutAllAsync() throws Exception {
        CompletableFuture f = this.remote().putAllAsync(Collections.singletonMap("k", "v3"));
        this.testFuture(f, null);
        this.testK("v3");
    }

    public void testPutAllAsyncWithListener() throws Exception {
        CompletableFuture f = this.remote().putAllAsync(Collections.singletonMap("k", "v3"));
        this.testFutureWithListener(f, null);
        this.testK("v3");
    }

    public void testPutIfAbsentAsync() throws Exception {
        this.remote().put((Object)"k", (Object)"v3");
        this.testK("v3");
        CompletableFuture f = this.remote().putIfAbsentAsync((Object)"k", (Object)"v4");
        this.testFuture(f, "v3");
        AssertJUnit.assertEquals((String)"v3", (String)((String)this.remote().remove((Object)"k")));
        f = this.remote().putIfAbsentAsync((Object)"k", (Object)"v5");
        this.testFuture(f, null);
        this.testK("v5");
    }

    public void testPutIfAbsentAsyncWithListener() throws Exception {
        this.remote().put((Object)"k", (Object)"v3");
        this.testK("v3");
        CompletableFuture f = this.remote().putIfAbsentAsync((Object)"k", (Object)"v4");
        this.testFutureWithListener(f, "v3");
        AssertJUnit.assertEquals((String)"v3", (String)((String)this.remote().remove((Object)"k")));
        f = this.remote().putIfAbsentAsync((Object)"k", (Object)"v5");
        this.testFutureWithListener(f, null);
        this.testK("v5");
    }

    public void testRemoveAsync() throws Exception {
        this.remote().put((Object)"k", (Object)"v3");
        this.testK("v3");
        CompletableFuture f = this.remote().removeAsync((Object)"k");
        this.testFuture(f, "v3");
        this.testK(null);
    }

    public void testRemoveAsyncWithListener() throws Exception {
        this.remote().put((Object)"k", (Object)"v3");
        this.testK("v3");
        CompletableFuture f = this.remote().removeAsync((Object)"k");
        this.testFutureWithListener(f, "v3");
        this.testK(null);
    }

    public void testGetAsync() throws Exception {
        this.remote().put((Object)"k", (Object)"v");
        this.testK("v");
        CompletableFuture f = this.remote().getAsync((Object)"k");
        this.testFuture(f, "v");
        this.testK("v");
    }

    public void testGetAsyncWithListener() throws Exception {
        this.remote().put((Object)"k", (Object)"v");
        this.testK("v");
        CompletableFuture f = this.remote().getAsync((Object)"k");
        this.testFutureWithListener(f, "v");
    }

    public void testRemoveWithVersionAsync() throws Exception {
        this.remote().put((Object)"k", (Object)"v4");
        VersionedValue value = this.remote().getVersioned((Object)"k");
        CompletableFuture f = this.remote().removeWithVersionAsync((Object)"k", value.getVersion() + 1L);
        this.testFuture(f, false);
        this.testK("v4");
        f = this.remote().removeWithVersionAsync((Object)"k", value.getVersion());
        this.testFuture(f, true);
        this.testK(null);
    }

    public void testRemoveWithVersionAsyncWithListener() throws Exception {
        this.remote().put((Object)"k", (Object)"v4");
        VersionedValue value = this.remote().getVersioned((Object)"k");
        CompletableFuture f = this.remote().removeWithVersionAsync((Object)"k", value.getVersion() + 1L);
        this.testFutureWithListener(f, false);
        this.testK("v4");
        f = this.remote().removeWithVersionAsync((Object)"k", value.getVersion());
        this.testFutureWithListener(f, true);
        this.testK(null);
    }

    public void testReplaceAsync() throws Exception {
        this.testK(null);
        CompletableFuture f = this.remote().replaceAsync((Object)"k", (Object)"v5");
        this.testFuture(f, null);
        this.testK(null);
        this.remote().put((Object)"k", (Object)"v");
        this.testK("v");
        f = this.remote().replaceAsync((Object)"k", (Object)"v5");
        this.testFuture(f, "v");
        this.testK("v5");
    }

    public void testReplaceAsyncWithListener() throws Exception {
        this.testK(null);
        CompletableFuture f = this.remote().replaceAsync((Object)"k", (Object)"v5");
        this.testFutureWithListener(f, null);
        this.testK(null);
        this.remote().put((Object)"k", (Object)"v");
        this.testK("v");
        f = this.remote().replaceAsync((Object)"k", (Object)"v5");
        this.testFutureWithListener(f, "v");
        this.testK("v5");
    }

    public void testReplaceWithVersionAsync() throws Exception {
        this.remote().put((Object)"k", (Object)"v");
        VersionedValue versioned1 = this.remote().getVersioned((Object)"k");
        CompletableFuture f = this.remote().replaceWithVersionAsync((Object)"k", (Object)"v2", versioned1.getVersion());
        this.testFuture(f, true);
        VersionedValue versioned2 = this.remote().getVersioned((Object)"k");
        Assert.assertNotEquals((Object)versioned1.getVersion(), (Object)versioned2.getVersion());
        AssertJUnit.assertEquals((Object)versioned2.getValue(), (Object)"v2");
        f = this.remote().replaceWithVersionAsync((Object)"k", (Object)"v3", versioned1.getVersion());
        this.testFuture(f, false);
        this.testK("v2");
    }

    public void testReplaceWithVersionAsyncWithListener() throws Exception {
        this.remote().put((Object)"k", (Object)"v");
        VersionedValue versioned1 = this.remote().getVersioned((Object)"k");
        CompletableFuture f = this.remote().replaceWithVersionAsync((Object)"k", (Object)"v2", versioned1.getVersion());
        this.testFutureWithListener(f, true);
        VersionedValue versioned2 = this.remote().getVersioned((Object)"k");
        Assert.assertNotEquals((Object)versioned1.getVersion(), (Object)versioned2.getVersion());
        AssertJUnit.assertEquals((Object)versioned2.getValue(), (Object)"v2");
        f = this.remote().replaceWithVersionAsync((Object)"k", (Object)"v3", versioned1.getVersion());
        this.testFutureWithListener(f, false);
        this.testK("v2");
    }

    private <T> void testK(T expected) {
        AssertJUnit.assertEquals(expected, (Object)this.remote().get((Object)"k"));
    }

    private <T> void testFuture(Future<T> f, T expected) throws ExecutionException, InterruptedException {
        AssertJUnit.assertNotNull(f);
        AssertJUnit.assertFalse((boolean)f.isCancelled());
        T value = f.get();
        AssertJUnit.assertEquals((String)("Obtained " + value), expected, value);
        AssertJUnit.assertTrue((boolean)f.isDone());
    }

    private <T> void testFutureWithListener(CompletableFuture<T> f, T expected) throws InterruptedException {
        AssertJUnit.assertNotNull(f);
        AtomicReference ex = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        f.whenComplete((v, t) -> {
            if (t != null) {
                ex.set(t);
            }
            AssertJUnit.assertEquals((String)("Obtained " + v), (Object)expected, (Object)v);
            latch.countDown();
        });
        if (!latch.await(5L, TimeUnit.SECONDS)) {
            AssertJUnit.fail((String)"Not finished within 5 seconds");
        }
        if (ex.get() != null) {
            throw new AssertionError(ex.get());
        }
    }
}

