/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterEventsTest")
public class ClientClusterEventsTest
extends MultiHotRodServersTest {
    static final int NUM_SERVERS = 2;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = ClientClusterEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    @Override
    protected HotRodServer addHotRodServer(ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        server.addCacheEventConverterFactory("static-converter-factory", new CustomEventLogListener.StaticConverterFactory());
        server.addCacheEventFilterConverterFactory("filter-converter-factory", (CacheEventFilterConverterFactory)new CustomEventLogListener.FilterConverterFactory());
        this.servers.add(server);
        return server;
    }

    public void testEventForwarding() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        EventLogListener l = new EventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)key0, (Object)"one");
            l.expectOnlyCreatedEvent(key0);
            remote.put((Object)key1, (Object)"two");
            l.expectOnlyCreatedEvent(key1);
            remote.replace((Object)key0, (Object)"new-one");
            l.expectOnlyModifiedEvent(key0);
            remote.replace((Object)key1, (Object)"new-two");
            l.expectOnlyModifiedEvent(key1);
            remote.remove((Object)key0);
            l.expectOnlyRemovedEvent(key0);
            remote.remove((Object)key1);
            l.expectOnlyRemovedEvent(key1);
        });
    }

    public void testFilteringInCluster() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        for (HotRodServer server : this.servers) {
            server.addCacheEventFilterFactory("static-filter-factory", new EventLogListener.StaticCacheEventFilterFactory<Integer>(key1));
        }
        EventLogListener.StaticFilteredEventLogListener l = new EventLogListener.StaticFilteredEventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)key0, (Object)"one");
            l.expectNoEvents();
            remote.put((Object)key1, (Object)"two");
            l.expectOnlyCreatedEvent(key1);
            remote.remove((Object)key0);
            l.expectNoEvents();
            remote.remove((Object)key1);
            l.expectOnlyRemovedEvent(key1);
        });
    }

    public void testConversionInCluster() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        CustomEventLogListener.StaticCustomEventLogListener l = new CustomEventLogListener.StaticCustomEventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)key0, (Object)"one");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, "one", 0));
            remote.put((Object)key1, (Object)"two");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, "two", 0));
            remote.remove((Object)key0);
            l.expectRemovedEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, null, 0));
            remote.remove((Object)key1);
            l.expectRemovedEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, null, 0));
        });
    }

    public void testFilterCustomEventsInCluster() {
        Integer key0 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
        Integer key1 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
        CustomEventLogListener.FilterCustomEventLogListener l = new CustomEventLogListener.FilterCustomEventLogListener(this.client(0).getCache());
        HotRodClientTestingUtil.withClientListener(l, new Object[]{key0}, null, remote -> {
            remote.put((Object)key0, (Object)"one");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, null, 1));
            remote.put((Object)key0, (Object)"newone");
            l.expectModifiedEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, null, 2));
            remote.put((Object)key1, (Object)"two");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, "two", 1));
            remote.put((Object)key1, (Object)"dos");
            l.expectModifiedEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, "dos", 2));
            remote.remove((Object)key0);
            l.expectRemovedEvent(new CustomEventLogListener.CustomEvent<Integer>(key0, null, 3));
            remote.remove((Object)key1);
            l.expectRemovedEvent(new CustomEventLogListener.CustomEvent<Integer>(key1, null, 3));
        });
    }
}

