/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientCustomFilterEventsTest")
public class ClientCustomFilterEventsTest
extends SingleHotRodServerTest {
    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
        server.addCacheEventFilterConverterFactory("filter-converter-factory", (CacheEventFilterConverterFactory)new CustomEventLogListener.FilterConverterFactory());
        return server;
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testIncorrectFilterFactory() {
        this.hotrodServer.addCacheEventFilterFactory("xxx", (CacheEventFilterFactory)new IncorrectFilterConverterFactory());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testIncorrectConverterFactory() {
        this.hotrodServer.addCacheEventConverterFactory("xxx", (CacheEventConverterFactory)new IncorrectFilterConverterFactory());
    }

    public void testFilterCustomEvents() {
        CustomEventLogListener.FilterCustomEventLogListener l = new CustomEventLogListener.FilterCustomEventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, new Object[]{1}, null, remote -> {
            remote.put((Object)1, (Object)"one");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, null, 1));
            remote.put((Object)1, (Object)"newone");
            l.expectModifiedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, null, 2));
            remote.put((Object)2, (Object)"two");
            l.expectCreatedEvent(new CustomEventLogListener.CustomEvent<Integer>(2, "two", 3));
            remote.put((Object)2, (Object)"dos");
            l.expectModifiedEvent(new CustomEventLogListener.CustomEvent<Integer>(2, "dos", 4));
            remote.remove((Object)1);
            l.expectRemovedEvent(new CustomEventLogListener.CustomEvent<Integer>(1, null, 5));
            remote.remove((Object)2);
            l.expectRemovedEvent(new CustomEventLogListener.CustomEvent<Integer>(2, null, 6));
        });
    }

    public static class IncorrectFilterConverterFactory
    implements CacheEventFilterFactory,
    CacheEventConverterFactory {
        public <K, V> CacheEventFilter<K, V> getFilter(Object[] params) {
            return null;
        }

        public <K, V, C> CacheEventConverter<K, V, C> getConverter(Object[] params) {
            return null;
        }
    }
}

