/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.JsonEventsTest")
public class JsonEventsTest
extends SingleHotRodServerTest {
    public void testCreatedEvent() {
        DataFormat jsonValues = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache().withDataFormat(jsonValues));
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"{\"key\":\"one\"}");
            l.expectOnlyCreatedEvent(1);
            remote.put((Object)2, (Object)"{\"key\":\"two\"}");
            l.expectOnlyCreatedEvent(2);
        });
    }
}

