/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.query.HotRodQueryTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.dsl.Query;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.HotRodQueryIspnDirectoryTest", groups={"functional"})
public class HotRodQueryIspnDirectoryTest
extends HotRodQueryTest {
    @Override
    protected ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = super.getConfigurationBuilder();
        builder.indexing().addProperty("default.directory_provider", "infinispan");
        return builder;
    }

    public void testReadAsJSON() throws Exception {
        DataFormat acceptJSON = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        RemoteCache jsonCache = this.remoteCache.withDataFormat(acceptJSON);
        JsonNode user1 = new ObjectMapper().readTree((String)jsonCache.get((Object)1));
        AssertJUnit.assertEquals((String)"Tom", (String)user1.get("name").asText());
        AssertJUnit.assertEquals((String)"Cat", (String)user1.get("surname").asText());
        Query query = Search.getQueryFactory((RemoteCache)jsonCache).create("FROM sample_bank_account.User where name = 'Tom'");
        List results = query.list();
        AssertJUnit.assertEquals((int)1, (int)query.getResultSize());
        Assert.assertNull((Object)query.getProjection());
        JsonNode jsonNode = new ObjectMapper().readTree((String)results.iterator().next());
        AssertJUnit.assertEquals((String)"Tom", (String)jsonNode.get("name").asText());
        AssertJUnit.assertEquals((String)"Cat", (String)jsonNode.get("surname").asText());
    }
}

