/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.RemoteQueryWithProtostreamAnnotationsTest", groups={"functional"})
public class RemoteQueryWithProtostreamAnnotationsTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createServerModeCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        return new RemoteCacheManager(clientBuilder.build());
    }

    @BeforeClass
    protected void registerProtobufSchema() throws Exception {
        String authorSchemaFile = "/* @Indexed */\nmessage Author {\n   required int32 id = 1;\n   /* @IndexedField */\n   required string name = 2;\n}";
        SerializationContext serializationContext = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager);
        serializationContext.registerProtoFiles(FileDescriptorSource.fromString((String)"author.proto", (String)authorSchemaFile));
        serializationContext.registerMarshaller((BaseMarshaller)new MessageMarshaller<Author>(){

            public Author readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
                int id = reader.readInt("id");
                String name = reader.readString("name");
                Author author = new Author();
                author.setId(id);
                author.setName(name);
                return author;
            }

            public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Author author) throws IOException {
                writer.writeInt("id", author.getId());
                writer.writeString("name", author.getName());
            }

            public Class<Author> getJavaClass() {
                return Author.class;
            }

            public String getTypeName() {
                return "Author";
            }
        });
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String memoSchemaFile = protoSchemaBuilder.fileName("memo.proto").addClass(Memo.class).build(serializationContext);
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"author.proto", (Object)authorSchemaFile);
        metadataCache.put((Object)"memo.proto", (Object)memoSchemaFile);
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
    }

    public void testAttributeQuery() throws Exception {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        remoteCache.put((Object)1, (Object)this.createMemo1());
        remoteCache.put((Object)2, (Object)this.createMemo2());
        Memo fromCache = (Memo)remoteCache.get((Object)1);
        this.assertMemo1(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)remoteCache);
        Query query = qf.from(Memo.class).having("text").like("%ipsum%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Memo.class, ((Memo)list.get(0)).getClass());
        this.assertMemo1((Memo)list.get(0));
        query = qf.from(Memo.class).having("author.name").eq((Object)"Adrian").build();
        list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Memo.class, ((Memo)list.get(0)).getClass());
        this.assertMemo2((Memo)list.get(0));
    }

    private Memo createMemo1() {
        Author author = new Author();
        author.setId(1);
        author.setName("Tom");
        Memo memo = new Memo();
        memo.setId(1);
        memo.setText("Lorem ipsum");
        memo.setAuthor(author);
        return memo;
    }

    private Memo createMemo2() {
        Author author = new Author();
        author.setId(2);
        author.setName("Adrian");
        Memo memo = new Memo();
        memo.setId(2);
        memo.setText("Sed ut perspiciatis unde omnis iste natus error");
        memo.setAuthor(author);
        return memo;
    }

    private void assertMemo1(Memo memo) {
        AssertJUnit.assertNotNull((Object)memo);
        AssertJUnit.assertEquals((int)1, (int)memo.getId());
        AssertJUnit.assertEquals((String)"Lorem ipsum", (String)memo.getText());
        AssertJUnit.assertEquals((int)1, (int)memo.getAuthor().getId());
    }

    private void assertMemo2(Memo memo) {
        AssertJUnit.assertNotNull((Object)memo);
        AssertJUnit.assertEquals((int)2, (int)memo.getId());
        AssertJUnit.assertEquals((String)"Sed ut perspiciatis unde omnis iste natus error", (String)memo.getText());
        AssertJUnit.assertEquals((int)2, (int)memo.getAuthor().getId());
    }

    public static class Author {
        private int id;
        private String name;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return "Author{id=" + this.id + ", name='" + this.name + "'}";
        }
    }

    @ProtoDoc(value="@Indexed")
    @ProtoMessage(name="Memo")
    public static class Memo {
        private int id;
        private String text;
        private Author author;

        @ProtoDoc(value="@Field(index = Index.NO, store = Store.NO)")
        @ProtoField(number=10, required=true)
        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @ProtoDoc(value="@IndexedField")
        @ProtoField(number=20)
        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        @ProtoDoc(value="@IndexedField")
        @ProtoField(number=30)
        public Author getAuthor() {
            return this.author;
        }

        public void setAuthor(Author author) {
            this.author = author;
        }

        public String toString() {
            return "Memo{id=" + this.id + ", text='" + this.text + '\'' + ", author=" + this.author + '}';
        }
    }
}

