/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.retry.CompleteShutdownReplRetryTest")
public class CompleteShutdownReplRetryTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
    }

    @Override
    protected int maxRetries() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRetryAfterCompleteShutdown() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)CompleteShutdownReplRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        this.createHotRodServers(3, builder);
        try {
            int initialServerPort = this.server(0).getPort();
            this.assertClusterSize("Cluster should be formed", 3);
            RemoteCache client = this.client(0).getCache();
            client.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)client.get((Object)1)));
            this.killServer(0);
            AssertJUnit.assertEquals((String)"one", (String)((String)client.get((Object)1)));
            this.killServer(0);
            AssertJUnit.assertEquals((String)"one", (String)((String)client.get((Object)1)));
            this.killServer(0);
            try {
                AssertJUnit.assertEquals((String)"one", (String)((String)client.get((Object)1)));
                AssertJUnit.fail((String)"Should have thrown exception");
            }
            catch (TransportException transportException) {
                // empty catch block
            }
            this.addHotRodServer(builder, initialServerPort);
            client.put((Object)1, (Object)"one");
            AssertJUnit.assertEquals((String)"one", (String)((String)client.get((Object)1)));
        }
        finally {
            this.destroy();
        }
    }
}

