/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.jgroups.SuspectedException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.retry.ServerFailureRetryTest")
public class ServerFailureRetryTest
extends AbstractRetryTest {
    @Override
    protected ConfigurationBuilder getCacheConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ServerFailureRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
    }

    public void testRetryWithInfinispanSuspectException() {
        this.retryExceptions(false);
    }

    public void testRetryWithJGroupsSuspectedException() {
        this.retryExceptions(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryExceptions(boolean throwJGroupsException) {
        AdvancedCache<?, ?> nextCache = this.cacheToHit(1);
        ErrorInducingInterceptor interceptor = new ErrorInducingInterceptor(throwJGroupsException);
        nextCache.getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)interceptor, 1);
        try {
            this.remoteCache.put((Object)1, (Object)"v1");
            AssertJUnit.assertTrue((boolean)interceptor.suspectExceptionThrown);
            AssertJUnit.assertEquals((Object)"v1", (Object)this.remoteCache.get((Object)1));
        }
        finally {
            nextCache.getAsyncInterceptorChain().removeInterceptor(ErrorInducingInterceptor.class);
        }
    }

    public void testRetryCacheStopped() {
        this.remoteCache.put((Object)1, (Object)"v1");
        AssertJUnit.assertEquals((Object)"v1", (Object)this.remoteCache.get((Object)1));
        AdvancedCache<?, ?> cache = this.cacheToHit(2);
        try {
            cache.stop();
            this.remoteCache.put((Object)2, (Object)"v2");
            AssertJUnit.assertEquals((Object)"v2", (Object)this.remoteCache.get((Object)2));
        }
        finally {
            cache.start();
        }
    }

    public static class ErrorInducingInterceptor
    extends CommandInterceptor {
        volatile boolean suspectExceptionThrown;
        boolean throwJGroupsException;

        public ErrorInducingInterceptor(boolean throwJGroupsException) {
            this.throwJGroupsException = throwJGroupsException;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (ctx.isOriginLocal()) {
                this.suspectExceptionThrown = true;
                throw this.throwJGroupsException ? new SuspectedException((Object)"Simulated suspicion") : new SuspectException("Simulated suspicion");
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }
    }
}

