/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.transcoding;

import com.fasterxml.jackson.databind.node.TextNode;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.client.hotrod.transcoding.ComplexKey;
import org.infinispan.client.hotrod.transcoding.JacksonMarshaller;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.ExternallyMarshallable;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional"}, testName="client.hotrod.transcoding.DataFormatTest")
public class DataFormatTest
extends SingleHotRodServerTest {
    private static final String CACHE_NAME = "test";
    private RemoteCache<Object, Object> remoteCache;

    public DataFormatTest() {
        ExternallyMarshallable.addToWhiteList((String)ComplexKey.class.getName());
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder buildCacheConfig() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.encoding().key().mediaType("application/x-jboss-marshalling");
        builder.encoding().value().mediaType("application/x-jboss-marshalling");
        return builder;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createServerModeCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.buildCacheConfig();
        this.cacheManager.defineConfiguration(CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder).build());
        return this.cacheManager;
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager, new HotRodServerConfigurationBuilder());
        server.addCacheEventFilterFactory("static-filter-factory", new EventLogListener.StaticCacheEventFilterFactory<Integer>(42));
        server.addCacheEventFilterFactory("raw-static-filter-factory", (CacheEventFilterFactory)new EventLogListener.RawStaticCacheEventFilterFactory());
        return server;
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache(CACHE_NAME);
    }

    @Test
    public void testValueInMultipleFormats() throws Exception {
        this.remoteCache.clear();
        String quote = "I find your lack of faith disturbing";
        byte[] jbossMarshalledQuote = this.marshall(quote);
        this.remoteCache.put((Object)1, (Object)quote);
        Object asBinary = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JBOSS_MARSHALLING).valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).get((Object)1);
        ArrayAsserts.assertArrayEquals((byte[])((byte[])asBinary), (byte[])jbossMarshalledQuote);
        Object asUTF8 = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).get((Object)1);
        ArrayAsserts.assertArrayEquals((byte[])quote.getBytes(StandardCharsets.UTF_8), (byte[])((byte[])asUTF8));
        Object asString = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build()).get((Object)1);
        AssertJUnit.assertEquals((Object)quote, (Object)asString);
        MetadataValue metadataValue = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build()).getWithMetadata((Object)1);
        AssertJUnit.assertEquals((Object)quote, (Object)metadataValue.getValue());
        Map allEntries = this.remoteCache.withDataFormat(DataFormat.builder().valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).getAll(new HashSet<Integer>(Collections.singletonList(1)));
        ArrayAsserts.assertArrayEquals((byte[])jbossMarshalledQuote, (byte[])((byte[])allEntries.get(1)));
        Object asJSon = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).build()).get((Object)1);
        ArrayAsserts.assertArrayEquals((byte[])("\"" + quote + "\"").getBytes(StandardCharsets.UTF_8), (byte[])((byte[])asJSon));
        Object asJSonNode = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new JacksonMarshaller()).build()).get((Object)1);
        AssertJUnit.assertEquals((Object)new TextNode(quote), (Object)asJSonNode);
        Object raw = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JBOSS_MARSHALLING).valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).values().iterator().next();
        ArrayAsserts.assertArrayEquals((byte[])((byte[])raw), (byte[])jbossMarshalledQuote);
        Object jsonNode = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new JacksonMarshaller()).build()).values().iterator().next();
        AssertJUnit.assertEquals((Object)jsonNode, (Object)new TextNode(quote));
    }

    @Test
    public void testKeysInMultipleFormats() throws Exception {
        this.remoteCache.clear();
        this.cacheManager.getClassWhiteList().addRegexps(new String[]{".*SocketAddress"});
        InetSocketAddress value = InetSocketAddress.createUnresolved("infinispan.org", 8080);
        this.remoteCache.put((Object)"1", (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.remoteCache.get((Object)"1"));
        this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.TEXT_PLAIN).keyMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).put((Object)"utf-key".getBytes(), (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.remoteCache.get((Object)"utf-key"));
        RemoteCache remoteCacheUTFKey = this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.TEXT_PLAIN).build());
        this.remoteCache.put((Object)"temp-key", (Object)value);
        Assert.assertTrue((boolean)remoteCacheUTFKey.containsKey((Object)"temp-key"));
        remoteCacheUTFKey.remove((Object)"temp-key");
        AssertJUnit.assertFalse((boolean)remoteCacheUTFKey.containsKey((Object)"temp-key"));
        AssertJUnit.assertEquals((Object)value, (Object)remoteCacheUTFKey.get((Object)"1"));
        Object asString = this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.TEXT_PLAIN).valueType(MediaType.TEXT_PLAIN).build()).get((Object)"1");
        AssertJUnit.assertEquals((Object)asString, (Object)"infinispan.org:8080");
        this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.APPLICATION_JBOSS_MARSHALLING).keyMarshaller((Marshaller)IdentityMarshaller.INSTANCE).valueType(MediaType.APPLICATION_JBOSS_MARSHALLING).valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build()).put((Object)this.marshall(1024), (Object)this.marshall(value));
        AssertJUnit.assertEquals((Object)value, (Object)this.remoteCache.get((Object)1024));
        boolean removed = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build()).remove((Object)1024, (Object)"wrong-address.com");
        AssertJUnit.assertFalse((boolean)removed);
        removed = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build()).remove((Object)1024, (Object)"infinispan.org:8080");
        Assert.assertTrue((boolean)removed);
        AssertJUnit.assertFalse((boolean)this.remoteCache.containsKey((Object)1024));
    }

    @Test
    public void testBatchOperations() {
        this.remoteCache.clear();
        this.cacheManager.getClassWhiteList().addClasses(new Class[]{ComplexKey.class});
        HashMap entries = new HashMap();
        IntStream.range(0, 50).forEach(i -> {
            ComplexKey key = new ComplexKey(String.valueOf(i), Float.valueOf(i));
            entries.put(key, UUID.randomUUID().toString());
        });
        this.remoteCache.putAll(entries);
        RemoteCache jsonCache = this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.APPLICATION_JSON).keyMarshaller((Marshaller)new UTF8StringMarshaller()).build());
        HashSet jsonKeys = new HashSet(jsonCache.keySet());
        jsonKeys.forEach(k -> Assert.assertTrue((boolean)k.contains("\"_type\":\"org.infinispan.client.hotrod.transcoding.ComplexKey\"")));
        HashMap newEntries = new HashMap();
        IntStream.range(50, 100).forEach(i -> {
            String jsonKey = "{\"_type\":\"org.infinispan.client.hotrod.transcoding.ComplexKey\",\"id\":\"" + i + "\",\"ratio\":" + i + "}";
            newEntries.put(jsonKey, UUID.randomUUID().toString());
        });
        jsonCache.putAll(newEntries);
        HashSet keys = new HashSet();
        IntStream.range(60, 70).forEach(i -> keys.add(new ComplexKey(String.valueOf(i), Float.valueOf(i))));
        Set returned = this.remoteCache.getAll(keys).keySet().stream().map(ComplexKey.class::cast).collect(Collectors.toSet());
        AssertJUnit.assertEquals(keys, returned);
    }

    @Test
    public void testListenersWithDifferentFormats() {
        this.remoteCache.clear();
        ComplexKey complexKey = new ComplexKey("Key-1", Float.valueOf(89.88f));
        DataFormat jsonStringFormat = DataFormat.builder().keyType(MediaType.APPLICATION_JSON).keyMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        EventLogListener l = new EventLogListener(this.remoteCache.withDataFormat(jsonStringFormat));
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            this.remoteCache.put((Object)complexKey, (Object)UUID.randomUUID());
            l.expectOnlyCreatedEvent("{\"_type\":\"org.infinispan.client.hotrod.transcoding.ComplexKey\",\"id\":\"Key-1\",\"ratio\":89.88}");
        });
    }

    @Test
    public void testNonRawFilteredListeners() {
        this.remoteCache.clear();
        RemoteCache remoteCache = this.remoteCache.withDataFormat(DataFormat.builder().valueType(MediaType.TEXT_PLAIN).build());
        EventLogListener.StaticFilteredEventLogListener l = new EventLogListener.StaticFilteredEventLogListener(remoteCache);
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            remoteCache.put((Object)1, (Object)"value1");
            l.expectNoEvents();
            remoteCache.put((Object)42, (Object)"value2");
            l.expectOnlyCreatedEvent(42);
        });
    }

    @Test
    public void testRawFilteredListeners() {
        this.remoteCache.clear();
        RemoteCache jsonCache = this.remoteCache.withDataFormat(DataFormat.builder().keyType(MediaType.APPLICATION_JSON).keyMarshaller((Marshaller)new UTF8StringMarshaller()).build());
        EventLogListener.RawStaticFilteredEventLogListener l = new EventLogListener.RawStaticFilteredEventLogListener(jsonCache);
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            jsonCache.put((Object)"1", (Object)UUID.randomUUID());
            l.expectNoEvents();
            jsonCache.put((Object)"2", (Object)UUID.randomUUID());
            l.expectOnlyCreatedEvent("2");
        });
    }

    @Test
    public void testJsonFromDefaultCache() {
        DataFormat jsonValues = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        RemoteCache cache = this.remoteCacheManager.getCache().withDataFormat(jsonValues);
        String value = "{\"json_key\":\"json_value\"}";
        cache.put((Object)1, (Object)value);
        String valueAsJson = (String)cache.get((Object)1);
        AssertJUnit.assertEquals((String)value, (String)valueAsJson);
    }

    private byte[] marshall(Object o) throws Exception {
        return this.remoteCache.getRemoteCacheManager().getMarshaller().objectToByteBuffer(o);
    }
}

