/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tx;

import java.lang.reflect.Method;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.Exceptions;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.tx.InvalidServerConfigTxTest")
public class InvalidServerConfigTxTest
extends SingleHotRodServerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonTxCache(Method method) throws SystemException, NotSupportedException {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        this.cacheManager.defineConfiguration(method.getName(), builder.build());
        RemoteCache cache = this.remoteCacheManager.getCache(method.getName(), TransactionMode.NON_XA);
        TransactionManager tm = cache.getTransactionManager();
        tm.begin();
        try {
            Exceptions.expectException(HotRodClientException.class, (String)"ISPN004084.*", () -> {
                String cfr_ignored_0 = (String)cache.put((Object)"k1", (Object)"v1");
            });
        }
        finally {
            tm.rollback();
        }
        HotRodClientTestingUtil.assertNoTransaction(this.remoteCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadCommitted(Method method) throws SystemException, NotSupportedException {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        this.cacheManager.defineConfiguration(method.getName(), builder.build());
        RemoteCache cache = this.remoteCacheManager.getCache(method.getName(), TransactionMode.NON_XA);
        TransactionManager tm = cache.getTransactionManager();
        tm.begin();
        try {
            Exceptions.expectException(HotRodClientException.class, (String)"ISPN004084.*", () -> {
                String cfr_ignored_0 = (String)cache.put((Object)"k1", (Object)"v1");
            });
        }
        finally {
            tm.rollback();
        }
        HotRodClientTestingUtil.assertNoTransaction(this.remoteCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOptimistic(Method method) throws SystemException, NotSupportedException {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
        this.cacheManager.defineConfiguration(method.getName(), builder.build());
        RemoteCache cache = this.remoteCacheManager.getCache(method.getName(), TransactionMode.NON_XA);
        TransactionManager tm = cache.getTransactionManager();
        tm.begin();
        try {
            Exceptions.expectException(HotRodClientException.class, (String)"ISPN004084.*", () -> {
                String cfr_ignored_0 = (String)cache.put((Object)"k1", (Object)"v1");
            });
        }
        finally {
            tm.rollback();
        }
        HotRodClientTestingUtil.assertNoTransaction(this.remoteCacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOkConfig(Method method) throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.cacheManager.defineConfiguration(method.getName(), builder.build());
        RemoteCache cache = this.remoteCacheManager.getCache(method.getName(), TransactionMode.NON_XA);
        TransactionManager tm = cache.getTransactionManager();
        tm.begin();
        try {
            cache.put((Object)"k1", (Object)"v1");
        }
        finally {
            tm.commit();
        }
        AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)"k1")));
        HotRodClientTestingUtil.assertNoTransaction(this.remoteCacheManager);
    }
}

