/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tx.util;

import java.lang.reflect.Method;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.internal.junit.ArrayAsserts;

public interface KeyValueGenerator<K, V> {
    public static final KeyValueGenerator<String, String> STRING_GENERATOR = new KeyValueGenerator<String, String>(){

        @Override
        public String generateKey(Method method, int index) {
            return TestingUtil.k((Method)method, (int)index);
        }

        @Override
        public String generateValue(Method method, int index) {
            return TestingUtil.v((Method)method, (int)index);
        }

        @Override
        public void assertValueEquals(String expected, String actual) {
            AssertJUnit.assertEquals((String)expected, (String)actual);
        }

        public String toString() {
            return "STRING";
        }
    };
    public static final KeyValueGenerator<byte[], byte[]> BYTE_ARRAY_GENERATOR = new KeyValueGenerator<byte[], byte[]>(){

        @Override
        public byte[] generateKey(Method method, int index) {
            return TestingUtil.k((Method)method, (int)index).getBytes();
        }

        @Override
        public byte[] generateValue(Method method, int index) {
            return TestingUtil.v((Method)method, (int)index).getBytes();
        }

        @Override
        public void assertValueEquals(byte[] expected, byte[] actual) {
            ArrayAsserts.assertArrayEquals((byte[])expected, (byte[])actual);
        }

        public String toString() {
            return "BYTE_ARRAY";
        }
    };
    public static final KeyValueGenerator<Object[], Object[]> GENERIC_ARRAY_GENERATOR = new KeyValueGenerator<Object[], Object[]>(){

        @Override
        public Object[] generateKey(Method method, int index) {
            return new Object[]{method.getName(), "key", index};
        }

        @Override
        public Object[] generateValue(Method method, int index) {
            return new Object[]{method.getName(), "value", index};
        }

        @Override
        public void assertValueEquals(Object[] expected, Object[] actual) {
            ArrayAsserts.assertArrayEquals((Object[])expected, (Object[])actual);
        }

        public String toString() {
            return "GENERIC_ARRAY";
        }
    };

    public K generateKey(Method var1, int var2);

    public V generateValue(Method var1, int var2);

    public void assertValueEquals(V var1, V var2);
}

