/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.MappingIterator;
import org.infinispan.query.core.impl.PartitionHandlingSupport;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.core.impl.SlicingCollector;
import org.infinispan.query.core.impl.TimedCollector;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

public abstract class BaseEmbeddedQuery<T>
extends BaseQuery<T> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)BaseEmbeddedQuery.class.getName());
    private static final int INITIAL_CAPACITY = 1000;
    protected final IckleParsingResult.StatementType statementType;
    protected final AdvancedCache<?, ?> cache;
    protected final PartitionHandlingSupport partitionHandlingSupport;
    protected final LocalQueryStatistics queryStatistics;

    protected BaseEmbeddedQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, IckleParsingResult.StatementType statementType, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults, LocalQueryStatistics queryStatistics, boolean local) {
        super(queryFactory, queryString, namedParameters, projection, startOffset, maxResults, local);
        this.statementType = statementType;
        this.cache = cache;
        this.partitionHandlingSupport = new PartitionHandlingSupport(cache);
        this.queryStatistics = queryStatistics;
    }

    public void resetQuery() {
    }

    public List<T> list() {
        return this.execute().list();
    }

    protected abstract void recordQuery(long var1);

    public QueryResult<T> execute() {
        this.partitionHandlingSupport.checkCacheAvailable();
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        QueryResult<T> result = this.executeInternal(this.getComparator());
        if (this.queryStatistics.isEnabled()) {
            this.recordQuery(start);
        }
        return result;
    }

    public CloseableIterator<T> iterator() {
        this.partitionHandlingSupport.checkCacheAvailable();
        Comparator<Comparable<?>[]> comparator = this.getComparator();
        if (comparator == null) {
            MappingIterator<ObjectFilter.FilterResult, Object> iterator = new MappingIterator<ObjectFilter.FilterResult, Object>(this.getInternalIterator(), this::mapFilterResult);
            return iterator;
        }
        QueryResult<T> result = this.executeInternal(comparator);
        return Closeables.iterator(result.list().iterator());
    }

    private QueryResult<T> executeInternal(Comparator<Comparable<?>[]> comparator) {
        try (CloseableIterator<ObjectFilter.FilterResult> iterator = this.getInternalIterator();){
            List<Object> results;
            if (!iterator.hasNext()) {
                QueryResult<?> queryResult = QueryResultImpl.EMPTY;
                return queryResult;
            }
            if (comparator == null) {
                SlicingCollector collector = new SlicingCollector(new TimedCollector(Collectors.toList(), this.timeout), this.startOffset, this.maxResults);
                List results2 = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).map(this::mapFilterResult).collect(collector);
                QueryResultImpl queryResultImpl = new QueryResultImpl((int)collector.getCount(), results2);
                return queryResultImpl;
            }
            log.warnPerfSortedNonIndexed(this.queryString);
            int[] count = new int[1];
            PriorityQueue queue = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).peek(filterResult -> {
                count[0] = count[0] + 1;
            }).collect(new TimedCollector<ObjectFilter.FilterResult, PriorityQueue, PriorityQueue>(Collector.of(() -> new PriorityQueue<ObjectFilter.FilterResult>(1000, new ReverseFilterResultComparator(comparator)), this::addToPriorityQueue, (q1, q2) -> q1, Collector.Characteristics.IDENTITY_FINISH), this.timeout));
            int queueSize = count[0];
            if (queue.size() > this.startOffset) {
                Object[] res = new Object[queue.size() - this.startOffset];
                int i = queue.size();
                while (i-- > this.startOffset) {
                    ObjectFilter.FilterResult r = (ObjectFilter.FilterResult)queue.remove();
                    res[i - this.startOffset] = this.mapFilterResult(r);
                }
                results = Arrays.asList(res);
            } else {
                results = Collections.emptyList();
            }
            QueryResultImpl queryResultImpl = new QueryResultImpl(queueSize, results);
            return queryResultImpl;
        }
    }

    private void addToPriorityQueue(PriorityQueue<ObjectFilter.FilterResult> queue, ObjectFilter.FilterResult filterResult) {
        queue.add(filterResult);
        if (this.maxResults != -1 && queue.size() > this.startOffset + this.maxResults) {
            queue.remove();
        }
    }

    protected abstract Comparator<Comparable<?>[]> getComparator();

    protected abstract CloseableIterator<ObjectFilter.FilterResult> getInternalIterator();

    public int getResultSize() {
        int count = 0;
        try (CloseableIterator<ObjectFilter.FilterResult> iterator = this.getInternalIterator();){
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        return count;
    }

    private Object mapFilterResult(ObjectFilter.FilterResult result) {
        return this.projection != null ? result.getProjection() : result.getInstance();
    }

    protected boolean isSelectStatement() {
        return this.statementType == IckleParsingResult.StatementType.SELECT;
    }

    public String toString() {
        return "BaseEmbeddedQuery{queryString=" + this.queryString + ", statementType=" + String.valueOf(this.statementType) + ", namedParameters=" + String.valueOf(this.namedParameters) + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + "}";
    }

    private static final class ReverseFilterResultComparator
    implements Comparator<ObjectFilter.FilterResult> {
        private final Comparator<Comparable<?>[]> comparator;

        private ReverseFilterResultComparator(Comparator<Comparable<?>[]> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(ObjectFilter.FilterResult o1, ObjectFilter.FilterResult o2) {
            return -this.comparator.compare(o1.getSortProjection(), o2.getSortProjection());
        }
    }
}

