/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.BaseEmbeddedQuery;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.impl.MappingIterator;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.util.logging.LogFactory;

public class HybridQuery<T, S>
extends BaseEmbeddedQuery<T> {
    private static final Log LOG = (Log)LogFactory.getLog(HybridQuery.class, Log.class);
    protected final ObjectFilter objectFilter;
    protected final Query<S> baseQuery;

    public HybridQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, IckleParsingResult.StatementType statementType, Map<String, Object> namedParameters, ObjectFilter objectFilter, long startOffset, int maxResults, Query<?> baseQuery, LocalQueryStatistics queryStatistics, boolean local) {
        super(queryFactory, cache, queryString, statementType, namedParameters, objectFilter.getProjection(), startOffset, maxResults, queryStatistics, local);
        this.objectFilter = objectFilter;
        this.baseQuery = baseQuery;
    }

    @Override
    protected void recordQuery(long time) {
        this.queryStatistics.hybridQueryExecuted(this.queryString, time);
    }

    @Override
    protected Comparator<Comparable<?>[]> getComparator() {
        return this.objectFilter.getComparator();
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getInternalIterator() {
        return new MappingIterator<Object, ObjectFilter.FilterResult>(this.getBaseIterator(), arg_0 -> ((ObjectFilter)this.objectFilter).filter(arg_0));
    }

    protected CloseableIterator<?> getBaseIterator() {
        return this.baseQuery.startOffset(0L).maxResults(Integer.MAX_VALUE).local(this.local).iterator();
    }

    @Override
    public QueryResult<T> execute() {
        if (this.isSelectStatement()) {
            return super.execute();
        }
        return new QueryResultImpl(this.executeStatement(), Collections.emptyList());
    }

    public int executeStatement() {
        if (this.isSelectStatement()) {
            throw LOG.unsupportedStatement();
        }
        try (CloseableIterator entryIterator = this.baseQuery.startOffset(0L).maxResults(-1).local(this.local).entryIterator();){
            MappingIterator<EntityEntry, ObjectFilter.FilterResult> it = new MappingIterator<EntityEntry, ObjectFilter.FilterResult>(entryIterator, e -> this.objectFilter.filter(e.key(), e.value()));
            int count = 0;
            while (it.hasNext()) {
                ObjectFilter.FilterResult fr = (ObjectFilter.FilterResult)it.next();
                Object removed = this.cache.remove(fr.getKey());
                if (removed == null) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public String toString() {
        return "HybridQuery{queryString=" + this.queryString + ", statementType=" + String.valueOf(this.statementType) + ", namedParameters=" + String.valueOf(this.namedParameters) + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + ", baseQuery=" + String.valueOf(this.baseQuery) + "}";
    }
}

