/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.NoSuchElementException;
import java.util.function.Function;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.commons.util.CloseableIterator;

public class MappingEntryIterator<K, S, T>
implements CloseableIterator<T> {
    private final CloseableIterator<EntityEntry<K, S>> entryIterator;
    private final Function<EntityEntry<K, S>, T> mapper;
    private long skip = 0L;
    private long max = -1L;
    private T current;
    private long index;

    public MappingEntryIterator(CloseableIterator<EntityEntry<K, S>> entryIterator, Function<EntityEntry<K, S>, T> mapper) {
        this.entryIterator = entryIterator;
        this.mapper = mapper;
    }

    public boolean hasNext() {
        this.updateNext();
        return this.current != null;
    }

    public T next() {
        if (this.hasNext()) {
            T element = this.current;
            this.current = null;
            return element;
        }
        throw new NoSuchElementException();
    }

    private void updateNext() {
        while (this.current == null && this.entryIterator.hasNext()) {
            EntityEntry next = (EntityEntry)this.entryIterator.next();
            T mapped = this.transform(next);
            if (mapped != null) {
                ++this.index;
            }
            if (this.index <= this.skip || this.max != -1L && this.index > this.skip + this.max) continue;
            this.current = mapped;
        }
    }

    private T transform(EntityEntry<K, S> next) {
        if (next == null) {
            return null;
        }
        if (this.mapper == null) {
            return (T)next.value();
        }
        return this.mapper.apply(next);
    }

    public MappingEntryIterator<K, S, T> skip(long skip) {
        this.skip = skip;
        return this;
    }

    public MappingEntryIterator<K, S, T> limit(long max) {
        this.max = max;
        return this;
    }

    public void close() {
        this.entryIterator.close();
    }
}

