/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.time.Instant;
import javax.security.auth.Subject;

public class ConnectionMetadata {
    static final AttributeKey<ConnectionMetadata> METADATA = AttributeKey.newInstance((String)"METADATA");
    private final Channel channel;
    private long id;
    private Subject subject;
    private String clientName;
    private String clientLibName;
    private String clientLibVersion;
    private String protocolVersion;
    private Instant created;

    public static ConnectionMetadata getInstance(Channel channel) {
        ConnectionMetadata existing = (ConnectionMetadata)channel.attr(METADATA).get();
        if (existing == null) {
            ConnectionMetadata metadata = new ConnectionMetadata(channel);
            existing = (ConnectionMetadata)channel.attr(METADATA).setIfAbsent((Object)metadata);
            return existing == null ? metadata : existing;
        }
        return existing;
    }

    private ConnectionMetadata(Channel channel) {
        this.channel = channel;
    }

    public void id(long id) {
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    public Subject subject() {
        return this.subject;
    }

    public SocketAddress localAddress() {
        return this.channel.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.channel.remoteAddress();
    }

    public String clientName() {
        return this.clientName;
    }

    public String clientLibraryName() {
        return this.clientLibName;
    }

    public String clientLibraryVersion() {
        return this.clientLibVersion;
    }

    public String protocolVersion() {
        return this.protocolVersion;
    }

    public void clientLibraryName(String name) {
        this.clientLibName = name;
    }

    public void clientLibraryVersion(String version) {
        this.clientLibVersion = version;
    }

    public void clientName(String name) {
        this.clientName = name;
    }

    public void created(Instant timestamp) {
        this.created = timestamp;
    }

    public Instant created() {
        return this.created;
    }

    public void subject(Subject subject) {
        this.subject = subject;
    }

    public void protocolVersion(String version) {
        this.protocolVersion = version;
    }
}

