/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.notice;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.jasig.maven.notice.LicenseLookupContext;
import org.jasig.maven.notice.LicenseLookupHelper;
import org.jasig.maven.notice.LicenseResolvingNodeVisitor;
import org.jasig.maven.notice.lookup.ArtifactLicense;
import org.jasig.maven.notice.lookup.LicenseLookup;
import org.jasig.maven.notice.lookup.MappedVersion;
import org.jasig.maven.notice.util.ResourceFinder;
import org.jasig.maven.notice.util.ResourceFinderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNoticeMojo
extends AbstractMojo {
    protected MavenProject project;
    protected DependencyTreeBuilder dependencyTreeBuilder;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector artifactCollector;
    protected MavenProjectBuilder mavenProjectBuilder;
    @Deprecated
    protected String[] licenseLookup = new String[0];
    private boolean skipChecks = false;
    protected String[] licenseMapping = new String[0];
    protected String noticeTemplate = "NOTICE.template";
    protected String noticeTemplatePlaceholder = "#GENERATED_NOTICES#";
    protected String outputDir = "";
    protected String fileName = "NOTICE";
    protected String encoding = "UTF-8";
    protected boolean includeChildDependencies = true;
    protected boolean generateChildNotices = true;
    protected String noticeMessage = "  {0} under {1}";
    private MessageFormat parsedNoticeMessage;
    protected Set<String> excludedModules = new LinkedHashSet<String>();

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Log logger = this.getLog();
        if (this.skipChecks) {
            logger.info((CharSequence)"NOTICE file checks are skipped.");
            return;
        }
        if (this.licenseLookup != null && this.licenseLookup.length > 0) {
            logger.warn((CharSequence)"'licenseLookup' configuration property is deprecated use 'licenseMapping' instead");
            if (this.licenseMapping != null && this.licenseMapping.length > 0) {
                throw new MojoFailureException("Both 'licenseMapping' and 'licenseLookup' configuration properties configured. Only one may be used.");
            }
            this.licenseMapping = this.licenseLookup;
        }
        if (!this.generateChildNotices && !this.project.isExecutionRoot()) {
            return;
        }
        ResourceFinder finder = this.getResourceFinder();
        LicenseLookupHelper licenseLookupHelper = new LicenseLookupHelper(logger, finder, this.licenseMapping);
        List remoteArtifactRepositories = this.project.getRemoteArtifactRepositories();
        LicenseResolvingNodeVisitor visitor = new LicenseResolvingNodeVisitor(logger, licenseLookupHelper, remoteArtifactRepositories, this.mavenProjectBuilder, this.localRepository);
        this.parseProject(this.project, visitor);
        Set<Artifact> unresolvedArtifacts = visitor.getUnresolvedArtifacts();
        this.checkUnresolved(unresolvedArtifacts);
        Map<String, String> resolvedLicenses = visitor.getResolvedLicenses();
        String noticeLines = this.generateNoticeLines(resolvedLicenses);
        String noticeTemplateContents = this.readNoticeTemplate(finder);
        String noticeContents = noticeTemplateContents.replaceAll(Pattern.quote(this.noticeTemplatePlaceholder), noticeLines);
        this.handleNotice(finder, noticeContents);
    }

    protected abstract void handleNotice(ResourceFinder var1, String var2) throws MojoFailureException;

    protected void parseProject(MavenProject project, DependencyNodeVisitor visitor) throws MojoExecutionException, MojoFailureException {
        Log logger = this.getLog();
        logger.info((CharSequence)("Parsing Dependencies for: " + project.getName()));
        DependencyNode tree = this.loadDependencyTree(project);
        tree.accept(visitor);
        if (!this.includeChildDependencies) {
            return;
        }
        List collectedProjects = project.getCollectedProjects();
        if (collectedProjects == null) {
            return;
        }
        for (MavenProject moduleProject : collectedProjects) {
            if (this.isExcluded(moduleProject, project.getArtifactId())) continue;
            this.parseProject(moduleProject, visitor);
        }
    }

    protected boolean isExcluded(MavenProject mavenProject, String rootArtifactId) {
        Log logger = this.getLog();
        String artifactId = mavenProject.getArtifactId();
        if (this.excludedModules.contains(artifactId)) {
            logger.info((CharSequence)("Skipping aggregation of child module " + mavenProject.getName() + " with excluded artifactId: " + artifactId));
            return true;
        }
        for (MavenProject parentProject = mavenProject.getParent(); parentProject != null && !rootArtifactId.equals(parentProject.getArtifactId()); parentProject = parentProject.getParent()) {
            String parentArtifactId = parentProject.getArtifactId();
            if (!this.excludedModules.contains(parentArtifactId)) continue;
            logger.info((CharSequence)("Skipping aggregation of child module " + mavenProject.getName() + " with excluded parent artifactId: " + parentArtifactId));
            return true;
        }
        return false;
    }

    protected void checkUnresolved(Set<Artifact> unresolvedArtifacts) throws MojoFailureException {
        Log logger = this.getLog();
        if (unresolvedArtifacts.isEmpty()) {
            return;
        }
        LicenseLookup licenseLookup = new LicenseLookup();
        List<ArtifactLicense> artifacts = licenseLookup.getArtifact();
        logger.error((CharSequence)"Failed to find Licenses for the following dependencies: ");
        for (Artifact unresolvedArtifact : unresolvedArtifacts) {
            logger.error((CharSequence)("\t" + unresolvedArtifact));
            ArtifactLicense artifactLicense = new ArtifactLicense();
            artifactLicense.setGroupId(unresolvedArtifact.getGroupId());
            artifactLicense.setArtifactId(unresolvedArtifact.getArtifactId());
            List<MappedVersion> mappedVersions = artifactLicense.getVersion();
            MappedVersion mappedVersion = new MappedVersion();
            mappedVersion.setValue(unresolvedArtifact.getVersion());
            mappedVersions.add(mappedVersion);
            artifacts.add(artifactLicense);
        }
        logger.error((CharSequence)"Try adding them to a 'licenseMapping' file.");
        File buildDir = new File(this.project.getBuild().getDirectory());
        File mappingsfile = new File(buildDir, "license-mappings.xml");
        try {
            FileUtils.forceMkdir((File)buildDir);
        }
        catch (IOException e) {
            logger.warn((CharSequence)("Failed to write stub license-mappings.xml file to: " + mappingsfile), (Throwable)e);
        }
        Marshaller marshaller = LicenseLookupContext.getMarshaller();
        try {
            marshaller.marshal((Object)licenseLookup, mappingsfile);
            logger.error((CharSequence)("A stub license-mapping.xml file containing the unresolved dependencies has been written to: " + mappingsfile));
        }
        catch (JAXBException e) {
            logger.warn((CharSequence)("Failed to write stub license-mappings.xml file to: " + mappingsfile), (Throwable)e);
        }
        throw new MojoFailureException("Failed to find Licenses for " + unresolvedArtifacts.size() + " artifacts");
    }

    protected String generateNoticeLines(Map<String, String> resolvedLicenses) {
        StringBuilder builder = new StringBuilder();
        MessageFormat messageFormat = this.getNoticeMessageFormat();
        for (Map.Entry<String, String> resolvedEntry : resolvedLicenses.entrySet()) {
            String line = messageFormat.format(new Object[]{resolvedEntry.getKey(), resolvedEntry.getValue()});
            builder.append(line).append(IOUtils.LINE_SEPARATOR);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final MessageFormat getNoticeMessageFormat() {
        MessageFormat messageFormat;
        AbstractNoticeMojo abstractNoticeMojo = this;
        synchronized (abstractNoticeMojo) {
            if (this.parsedNoticeMessage == null || !this.noticeMessage.equals(this.parsedNoticeMessage.toPattern())) {
                this.parsedNoticeMessage = new MessageFormat(this.noticeMessage);
            }
            messageFormat = this.parsedNoticeMessage;
        }
        return messageFormat;
    }

    protected String readNoticeTemplate(ResourceFinder finder) throws MojoFailureException {
        URL inputFile = finder.findResource(this.noticeTemplate);
        StringBuilder noticeTemplateContents = new StringBuilder();
        InputStream inputStream = null;
        try {
            inputStream = inputFile.openStream();
            LineIterator lineIterator = IOUtils.lineIterator((InputStream)new BufferedInputStream(inputStream), (String)this.encoding);
            while (lineIterator.hasNext()) {
                String line = lineIterator.next();
                noticeTemplateContents.append(line).append(IOUtils.LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to open NOTICE Template File '" + this.noticeTemplate + "' from: " + inputFile, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return noticeTemplateContents.toString();
    }

    protected File getNoticeOutputFile() {
        File outputPath;
        if (this.outputDir == null) {
            this.outputDir = "";
        }
        if (!(outputPath = new File(this.outputDir)).isAbsolute()) {
            outputPath = new File(this.project.getBasedir(), this.outputDir);
        }
        return new File(outputPath, this.fileName);
    }

    protected ResourceFinder getResourceFinder() throws MojoExecutionException {
        ResourceFinderImpl finder = new ResourceFinderImpl(this.project);
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            finder.setCompileClassPath(classpathElements);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finder.setPluginClassPath(((Object)((Object)this)).getClass().getClassLoader());
        return finder;
    }

    protected DependencyNode loadDependencyTree(MavenProject project) throws MojoExecutionException {
        try {
            return this.dependencyTreeBuilder.buildDependencyTree(project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, null, this.artifactCollector);
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Cannot build project dependency tree for project: " + project, (Exception)((Object)e));
        }
    }
}

