/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.test.jspec;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.javalite.common.Inflector;
import org.javalite.test.jspec.TestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expectation<T> {
    private T actual;

    public Expectation(T actual) {
        this.actual = actual;
    }

    public Expectation() {
    }

    public void shouldEqual(T expected) {
        this.shouldBeEqual(expected);
    }

    public void shouldBeEqual(T expected) {
        Double t2;
        Double t1;
        this.checkNull();
        String expectedName = expected == null ? "null" : expected.getClass().getName();
        String actualName = this.actual == null ? "null" : this.actual.getClass().getName();
        TestException te = new TestException("\nTest object: \n" + actualName + " == <" + this.actual + "> \n" + "and expected\n" + expectedName + " == <" + expected + "> \nare not equal, but they should be.");
        if (this.actual == null && expected != null || this.actual != null && expected == null) {
            throw te;
        }
        if (this.actual instanceof Number && expected instanceof Number ? !(t1 = Double.valueOf(((Number)this.actual).doubleValue())).equals(t2 = Double.valueOf(((Number)expected).doubleValue())) : !this.actual.equals(expected)) {
            throw te;
        }
    }

    public void shouldHave(String booleanMethod) {
        this.shouldBe(booleanMethod);
    }

    public void shouldNotHave(String booleanMethod) {
        this.shouldNotBe(booleanMethod);
    }

    public void shouldBe(String booleanMethod) {
        this.invokeBoolean(booleanMethod, true);
    }

    public void shouldNotBe(String booleanMethod) {
        this.invokeBoolean(booleanMethod, false);
    }

    public void shouldNotBeEqual(T expected) {
        this.checkNull();
        if (this.actual.equals(expected)) {
            throw new TestException("Objects: '" + this.actual + "' and '" + expected + "' are equal, but they should not be");
        }
    }

    public void shouldNotBeNull() {
        if (this.actual == null) {
            throw new TestException("Object is null, while it is not expected");
        }
    }

    public void shouldBeType(Class clazz) {
        this.checkNull();
        if (!clazz.isAssignableFrom(this.actual.getClass())) {
            throw new TestException(this.actual.getClass() + " is not " + clazz);
        }
    }

    public void shouldBeA(Class clazz) {
        this.shouldBeType(clazz);
    }

    public void shouldBeFalse() {
        this.checkNull();
        if (((Boolean)this.actual).booleanValue()) {
            throw new TestException("should not be true, but it is");
        }
    }

    public void shouldBeTrue() {
        this.checkNull();
        if (!((Boolean)this.actual).booleanValue()) {
            throw new TestException("should be true, but it is not");
        }
    }

    public void shouldBeNull() {
        if (this.actual != null) {
            throw new TestException("argument is not null, but it should be");
        }
    }

    public void shouldBeTheSameAs(T expected) {
        this.checkNull();
        if (this.actual != expected) {
            throw new TestException("references are not the same, but they should be");
        }
    }

    public void shouldContain(Object expected) {
        if (!this.contains(expected)) {
            throw new TestException("tested value does not contain expected value: " + expected);
        }
    }

    public void shouldNotContain(Object expected) {
        if (this.contains(expected)) {
            throw new TestException("tested value contain expected value: " + expected + ", but it should not");
        }
    }

    private boolean contains(Object expected) {
        Map actualMap;
        List actualList;
        this.checkNull();
        if (this.actual instanceof List && (actualList = (List)this.actual).contains(expected)) {
            return true;
        }
        if (this.actual instanceof Map && (actualMap = (Map)this.actual).containsKey(expected)) {
            return true;
        }
        return this.actual.toString().contains(expected.toString());
    }

    public void shouldNotBeTheSameAs(T expected) {
        this.checkNull();
        if (this.actual == expected) {
            throw new TestException("references are the same, but they should not be");
        }
    }

    private void invokeBoolean(String booleanMethod, boolean returnValue) {
        this.checkNull();
        Method m = null;
        try {
            String methodName1 = "is" + Inflector.capitalize(booleanMethod);
            String methodName2 = "has" + Inflector.capitalize(booleanMethod);
            if (m == null) {
                try {
                    m = this.actual.getClass().getMethod(methodName1, new Class[0]);
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
            if (m == null) {
                try {
                    m = this.actual.getClass().getMethod(methodName2, new Class[0]);
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
            if (m == null) {
                throw new IllegalArgumentException("failed to find a matching method for class: " + this.actual.getClass() + ", named: " + methodName1 + " or " + methodName2);
            }
            boolean result = (Boolean)m.invoke(this.actual, new Object[0]);
            if (returnValue != result) {
                throw new TestException("Method: " + m.getName() + " should return " + returnValue + ", but returned " + result);
            }
        }
        catch (TestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkNull() {
        if (this.actual == null) {
            throw new IllegalArgumentException("tested value is null");
        }
    }
}

