/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.htmlunit.WebClient;
import org.htmlunit.WebClientOptions;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.CapabilitiesOptionsMapper;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.htmlunit.DroneHtmlUnitDriver;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;

public class HtmlUnitDriverFactory
extends AbstractWebDriverFactory<DroneHtmlUnitDriver>
implements Configurator<DroneHtmlUnitDriver, WebDriverConfiguration>,
Instantiator<DroneHtmlUnitDriver, WebDriverConfiguration>,
Destructor<DroneHtmlUnitDriver> {
    private static final String BROWSER_NAME = new BrowserCapabilitiesList.HtmlUnit().getReadableName();
    static final String webClientOptions = "htmlUnitWebClientOptions";
    private static final Logger logger = Logger.getLogger(HtmlUnitDriverFactory.class.getName());

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(DroneHtmlUnitDriver instance) {
        instance.quit();
    }

    public DroneHtmlUnitDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = this.getCapabilities(configuration, true);
        DroneHtmlUnitDriver droneHtmlUnitDriver = SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, DroneHtmlUnitDriver.class);
        String htmlUnitClientOptions = (String)capabilities.getCapability(webClientOptions);
        if (Validate.nonEmpty(htmlUnitClientOptions)) {
            WebClient webClient = droneHtmlUnitDriver.getWebClient();
            this.setClientOptions(webClient, htmlUnitClientOptions);
        }
        return droneHtmlUnitDriver;
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        MutableCapabilities caps = new MutableCapabilities(configuration.getCapabilities());
        caps.setCapability("browserName", BROWSER_NAME);
        return new ImmutableCapabilities((Capabilities)caps);
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_NAME;
    }

    private void setClientOptions(WebClient webClient, String htmlUnitWebClientOptions) {
        String[] options;
        WebClientOptions webClientOptions = webClient.getOptions();
        LinkedHashMap<String, String> clientOptions = new LinkedHashMap<String, String>();
        String multiline = StringUtils.trimMultiline(htmlUnitWebClientOptions);
        for (String option : options = multiline.split(";")) {
            String[] keyValue = option.split("=");
            if (keyValue.length != 2) continue;
            String key = keyValue[0].trim();
            if (key.length() > 0) {
                key = BROWSER_NAME + Character.toUpperCase(key.charAt(0)) + key.substring(1);
                String value = keyValue[1].trim();
                if (value.contains(",")) {
                    value = value.replaceAll("\\s*,\\s*", " ");
                }
                clientOptions.put(key, value);
                continue;
            }
            logger.info("Excluding option : " + option + "to set for HtmlUnitDriver webClientOptions as it is not as per required format i.e. key=value");
        }
        ImmutableCapabilities webClientCapabilities = new ImmutableCapabilities(clientOptions);
        logger.info("Setting HtmlDriver web client options: " + clientOptions);
        CapabilitiesOptionsMapper.mapCapabilities(webClientOptions, (Capabilities)webClientCapabilities, BROWSER_NAME);
    }
}

