/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableRemoteWebDriver;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverFactory
extends AbstractWebDriverFactory<WebDriver>
implements Configurator<WebDriver, WebDriverConfiguration>,
Instantiator<WebDriver, WebDriverConfiguration>,
Destructor<WebDriver> {
    private static final Logger log = Logger.getLogger(WebDriverFactory.class.getName());
    @Inject
    private Instance<DroneRegistry> registryInstance;

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(WebDriver instance) {
        Destructor destructor = null;
        if (instance instanceof ReusableRemoteWebDriver) {
            destructor = this.getRemoteWebDriverDestructor();
        } else {
            try {
                destructor = (Destructor)((DroneRegistry)this.registryInstance.get()).getEntryFor(instance.getClass(), Destructor.class);
            }
            catch (Exception ignored) {
                log.log(Level.WARNING, "Unable to get destructor for @Drone WebDriver, real class {0}, quitting instance using default disposal method", instance.getClass().getSimpleName());
            }
        }
        if (destructor != null && !destructor.getClass().equals(this.getClass())) {
            destructor.destroyInstance((Object)instance);
        } else {
            instance.quit();
        }
    }

    public WebDriver createInstance(WebDriverConfiguration configuration) {
        Instantiator instantiator;
        String implementationClassName = null;
        if (configuration.isRemoteReusable() || configuration.isRemote()) {
            instantiator = this.getRemoteWebDriverInstantiator();
        } else {
            implementationClassName = configuration.getImplementationClass();
            Validate.isEmpty(implementationClassName, "The combination of browser=" + configuration.getBrowserName() + ", implemenationClass=" + implementationClassName + " does not represent a valid browser. Please specify supported browser.");
            DroneRegistry registry = (DroneRegistry)this.registryInstance.get();
            Class<?> implementationClass = SecurityActions.getClass(implementationClassName);
            instantiator = (Instantiator)registry.getEntryFor(implementationClass, Instantiator.class);
        }
        if (instantiator != null && instantiator.getClass() != this.getClass()) {
            return (WebDriver)instantiator.createInstance((DroneConfiguration)configuration);
        }
        if (Validate.empty(implementationClassName)) {
            WebDriver driver = SecurityActions.newInstance(implementationClassName, new Class[0], new Object[0], WebDriver.class);
            return driver;
        }
        throw new IllegalStateException("Unable to create Arquillian WebDriver browser, please set \"browser\" property");
    }

    @Override
    protected String getDriverReadableName() {
        return null;
    }

    private Instantiator getRemoteWebDriverInstantiator() {
        DroneRegistry registry = (DroneRegistry)this.registryInstance.get();
        return (Instantiator)registry.getEntryFor(RemoteWebDriver.class, Instantiator.class);
    }

    private Destructor getRemoteWebDriverDestructor() {
        DroneRegistry registry = (DroneRegistry)this.registryInstance.get();
        return (Destructor)registry.getEntryFor(RemoteWebDriver.class, Destructor.class);
    }
}

