/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.channels.Channels;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSourceChannel;

public class BufferedChannelInputStream
extends InputStream {
    private final StreamSourceChannel channel;
    private final ByteBuffer buffer;
    private volatile boolean closed;
    private volatile long timeout;

    public BufferedChannelInputStream(StreamSourceChannel channel, int bufferSize) {
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be at least one byte");
        }
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
    }

    public BufferedChannelInputStream(StreamSourceChannel channel, int bufferSize, long timeout, TimeUnit unit) {
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is null");
        }
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be at least one byte");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
        long calcTimeout = unit.toMillis(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    public long getReadTimeout(TimeUnit unit) {
        return unit.convert(this.timeout, TimeUnit.MILLISECONDS);
    }

    public void setReadTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        long calcTimeout = unit.toMillis(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        ByteBuffer buffer = this.buffer;
        StreamSourceChannel channel = this.channel;
        long timeout = this.timeout;
        if (timeout == 0L) {
            while (!buffer.hasRemaining()) {
                buffer.clear();
                int res = Channels.readBlocking(channel, buffer);
                if (res == -1) {
                    return -1;
                }
                buffer.flip();
            }
        } else if (!buffer.hasRemaining()) {
            long now = System.currentTimeMillis();
            long deadline = timeout - now;
            do {
                buffer.clear();
                if (deadline <= now) {
                    throw new ReadTimeoutException("Read timed out");
                }
                int res = Channels.readBlocking(channel, buffer, deadline - now, TimeUnit.MILLISECONDS);
                if (res == -1) {
                    return -1;
                }
                buffer.flip();
            } while (!buffer.hasRemaining());
        }
        return buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int total;
        block13: {
            if (len < 1) {
                return 0;
            }
            total = 0;
            ByteBuffer buffer = this.buffer;
            if (buffer.hasRemaining()) {
                int cnt = Math.min(buffer.remaining(), len);
                buffer.get(b, off, len);
                total += cnt;
                off += cnt;
                len -= cnt;
            }
            if (this.closed) {
                return -1;
            }
            StreamSourceChannel channel = this.channel;
            long timeout = this.timeout;
            try {
                if (timeout == 0L) {
                    while (len > 0) {
                        int res;
                        ByteBuffer dst = ByteBuffer.wrap(b, off, len);
                        int n = res = total > 0 ? channel.read(dst) : Channels.readBlocking(channel, dst);
                        if (res == -1) {
                            return total == 0 ? -1 : total;
                        }
                        total += res;
                        if (res != 0) continue;
                        break block13;
                    }
                    break block13;
                }
                while (len > 0) {
                    int res;
                    ByteBuffer dst = ByteBuffer.wrap(b, off, len);
                    if (total > 0) {
                        res = channel.read(dst);
                    } else {
                        res = Channels.readBlocking(channel, dst, timeout, TimeUnit.MILLISECONDS);
                        if (res == 0) {
                            throw new ReadTimeoutException("Read timed out");
                        }
                    }
                    if (res == -1) {
                        return total == 0 ? -1 : total;
                    }
                    total += res;
                    if (res != 0) continue;
                    break;
                }
            }
            catch (InterruptedIOException e) {
                e.bytesTransferred = total;
                throw e;
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        long total = 0L;
        ByteBuffer buffer = this.buffer;
        if (buffer.hasRemaining()) {
            int cnt = (int)Math.min((long)buffer.remaining(), n);
            Buffers.skip(buffer, cnt);
            total += (long)cnt;
            n -= (long)cnt;
        }
        if (this.closed) {
            return total;
        }
        StreamSourceChannel channel = this.channel;
        if (n > 0L) {
            try {
                while (n > 0L) {
                    int res;
                    buffer.clear();
                    int n2 = res = total > 0L ? channel.read(buffer) : Channels.readBlocking(channel, buffer);
                    if (res <= 0) {
                        long l = total;
                        return l;
                    }
                    total += (long)res;
                }
            }
            finally {
                buffer.position(0).limit(0);
            }
        }
        return total;
    }

    @Override
    public int available() throws IOException {
        ByteBuffer buffer = this.buffer;
        int rem = buffer.remaining();
        if (rem > 0 || this.closed) {
            return rem;
        }
        buffer.clear();
        try {
            this.channel.read(buffer);
        }
        catch (IOException e) {
            buffer.limit(0);
            throw e;
        }
        buffer.flip();
        return buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.channel.shutdownReads();
    }
}

