/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.range.BigDecimalRangeRandomizer;
import org.jeasy.random.randomizers.range.BigIntegerRangeRandomizer;
import org.jeasy.random.randomizers.range.ByteRangeRandomizer;
import org.jeasy.random.randomizers.range.IntegerRangeRandomizer;
import org.jeasy.random.randomizers.range.LongRangeRandomizer;
import org.jeasy.random.randomizers.range.ShortRangeRandomizer;
import org.jeasy.random.randomizers.text.StringDelegatingRandomizer;
import org.jeasy.random.validation.BeanValidationAnnotationHandler;

public abstract class AbstractNumberBaseAnnotationHandler
implements BeanValidationAnnotationHandler {
    private final Random random;

    AbstractNumberBaseAnnotationHandler(long seed) {
        this.random = new Random(seed);
    }

    protected Randomizer<?> getRandomizer(Class<?> fieldType, BigDecimal minValue, BigDecimal maxValue) {
        if (fieldType.equals(Byte.TYPE) || fieldType.equals(Byte.class)) {
            return new ByteRangeRandomizer(minValue == null ? null : Byte.valueOf(minValue.byteValue()), maxValue == null ? null : Byte.valueOf(maxValue.byteValue()), this.random.nextLong());
        }
        if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
            return new ShortRangeRandomizer(minValue == null ? null : Short.valueOf(minValue.shortValue()), maxValue == null ? null : Short.valueOf(maxValue.shortValue()), this.random.nextLong());
        }
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
            return new IntegerRangeRandomizer(minValue == null ? null : Integer.valueOf(minValue.intValue()), maxValue == null ? null : Integer.valueOf(maxValue.intValue()), this.random.nextLong());
        }
        if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
            return new LongRangeRandomizer(minValue == null ? null : Long.valueOf(minValue.longValue()), maxValue == null ? null : Long.valueOf(maxValue.longValue()), this.random.nextLong());
        }
        if (fieldType.equals(BigInteger.class)) {
            return new BigIntegerRangeRandomizer(minValue == null ? null : Integer.valueOf(minValue.intValue()), maxValue == null ? null : Integer.valueOf(maxValue.intValue()), this.random.nextLong());
        }
        if (fieldType.equals(BigDecimal.class)) {
            return new BigDecimalRangeRandomizer(minValue == null ? null : Double.valueOf(minValue.doubleValue()), maxValue == null ? null : Double.valueOf(maxValue.doubleValue()), this.random.nextLong());
        }
        if (fieldType.equals(String.class)) {
            BigDecimalRangeRandomizer delegate = new BigDecimalRangeRandomizer(minValue == null ? null : Double.valueOf(minValue.doubleValue()), maxValue == null ? null : Double.valueOf(maxValue.doubleValue()), this.random.nextLong());
            return new StringDelegatingRandomizer((Randomizer)delegate);
        }
        return null;
    }
}

