/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.validation.BeanValidationAnnotationHandler;

class PastAnnotationHandler
implements BeanValidationAnnotationHandler {
    private EasyRandom easyRandom;
    private EasyRandomParameters parameters;

    PastAnnotationHandler(EasyRandomParameters parameters) {
        this.parameters = parameters.copy();
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        if (this.easyRandom == null) {
            LocalDate now = LocalDate.now();
            this.parameters.setDateRange(new EasyRandomParameters.Range((Object)now.minusYears(10L), (Object)now.minus(1L, ChronoUnit.DAYS)));
            this.easyRandom = new EasyRandom(this.parameters);
        }
        return () -> this.easyRandom.nextObject(field.getType());
    }
}

