/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.validation;

import java.lang.reflect.Field;
import java.util.Random;
import javax.validation.constraints.Pattern;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.RegularExpressionRandomizer;
import org.jeasy.random.util.ReflectionUtils;
import org.jeasy.random.validation.BeanValidationAnnotationHandler;

class PatternAnnotationHandler
implements BeanValidationAnnotationHandler {
    private final Random random;

    PatternAnnotationHandler(long seed) {
        this.random = new Random(seed);
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        Class<?> fieldType = field.getType();
        Pattern patternAnnotation = (Pattern)ReflectionUtils.getAnnotation((Field)field, Pattern.class);
        String regex = patternAnnotation.regexp();
        if (fieldType.equals(String.class)) {
            return new RegularExpressionRandomizer(regex, this.random.nextLong());
        }
        return null;
    }
}

