/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.mvel;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.mvel.MVELRule;
import org.jeasy.rules.support.ActivationRuleGroup;
import org.jeasy.rules.support.ConditionalRuleGroup;
import org.jeasy.rules.support.RuleDefinition;
import org.jeasy.rules.support.RuleDefinitionReader;
import org.jeasy.rules.support.UnitRuleGroup;
import org.jeasy.rules.support.YamlRuleDefinitionReader;
import org.mvel2.ParserContext;

public class MVELRuleFactory {
    private static final RuleDefinitionReader READER = new YamlRuleDefinitionReader();
    private RuleDefinitionReader reader;
    private static final List<String> ALLOWED_COMPOSITE_RULE_TYPES = Arrays.asList(UnitRuleGroup.class.getSimpleName(), ConditionalRuleGroup.class.getSimpleName(), ActivationRuleGroup.class.getSimpleName());

    public MVELRuleFactory(RuleDefinitionReader reader) {
        this.reader = reader;
    }

    public Rule createRule(Reader ruleDescriptor) throws Exception {
        return this.createRule(ruleDescriptor, new ParserContext());
    }

    public Rule createRule(Reader ruleDescriptor, ParserContext parserContext) throws Exception {
        List ruleDefinitions = this.reader.read(ruleDescriptor);
        if (ruleDefinitions.isEmpty()) {
            throw new IllegalArgumentException("rule descriptor is empty");
        }
        return MVELRuleFactory.createRule((RuleDefinition)ruleDefinitions.get(0), parserContext);
    }

    @Deprecated
    public static Rule createRuleFrom(Reader ruleDescriptor) throws Exception {
        return MVELRuleFactory.createRuleFrom(ruleDescriptor, new ParserContext());
    }

    @Deprecated
    public static Rule createRuleFrom(Reader ruleDescriptor, ParserContext parserContext) throws Exception {
        List ruleDefinitions = READER.read(ruleDescriptor);
        if (ruleDefinitions.isEmpty()) {
            throw new IllegalArgumentException("rule descriptor is empty");
        }
        return MVELRuleFactory.createRule((RuleDefinition)ruleDefinitions.get(0), parserContext);
    }

    public Rules createRules(Reader rulesDescriptor) throws Exception {
        return this.createRules(rulesDescriptor, new ParserContext());
    }

    public Rules createRules(Reader rulesDescriptor, ParserContext parserContext) throws Exception {
        Rules rules = new Rules(new Rule[0]);
        List ruleDefinition = this.reader.read(rulesDescriptor);
        for (RuleDefinition mvelRuleDefinition : ruleDefinition) {
            rules.register((Object)MVELRuleFactory.createRule(mvelRuleDefinition, parserContext));
        }
        return rules;
    }

    @Deprecated
    public static Rules createRulesFrom(Reader rulesDescriptor) throws Exception {
        return MVELRuleFactory.createRulesFrom(rulesDescriptor, new ParserContext());
    }

    @Deprecated
    public static Rules createRulesFrom(Reader rulesDescriptor, ParserContext parserContext) throws Exception {
        Rules rules = new Rules(new Rule[0]);
        List ruleDefinition = READER.read(rulesDescriptor);
        for (RuleDefinition mvelRuleDefinition : ruleDefinition) {
            rules.register((Object)MVELRuleFactory.createRule(mvelRuleDefinition, parserContext));
        }
        return rules;
    }

    private static Rule createRule(RuleDefinition ruleDefinition, ParserContext context) {
        if (ruleDefinition.isCompositeRule()) {
            return MVELRuleFactory.createCompositeRule(ruleDefinition, context);
        }
        return MVELRuleFactory.createSimpleRule(ruleDefinition, context);
    }

    private static Rule createSimpleRule(RuleDefinition ruleDefinition, ParserContext parserContext) {
        MVELRule mvelRule = new MVELRule().name(ruleDefinition.getName()).description(ruleDefinition.getDescription()).priority(ruleDefinition.getPriority()).when(ruleDefinition.getCondition(), parserContext);
        for (String action : ruleDefinition.getActions()) {
            mvelRule.then(action, parserContext);
        }
        return mvelRule;
    }

    private static Rule createCompositeRule(RuleDefinition ruleDefinition, ParserContext parserContext) {
        UnitRuleGroup compositeRule;
        String name = ruleDefinition.getName();
        switch (ruleDefinition.getCompositeRuleType()) {
            case "UnitRuleGroup": {
                compositeRule = new UnitRuleGroup(name);
                break;
            }
            case "ActivationRuleGroup": {
                compositeRule = new ActivationRuleGroup(name);
                break;
            }
            case "ConditionalRuleGroup": {
                compositeRule = new ConditionalRuleGroup(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid composite rule type, must be one of " + ALLOWED_COMPOSITE_RULE_TYPES);
            }
        }
        compositeRule.setDescription(ruleDefinition.getDescription());
        compositeRule.setPriority(ruleDefinition.getPriority());
        for (RuleDefinition composingRuleDefinition : ruleDefinition.getComposingRules()) {
            compositeRule.addRule((Object)MVELRuleFactory.createRule(composingRuleDefinition, parserContext));
        }
        return compositeRule;
    }
}

