/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.starter.cloud.util;

import com.alibaba.fastjson.JSONObject;
import java.util.SortedMap;
import org.jeecg.common.exception.JeecgCloudException;
import org.jeecg.common.util.SpringContextHolder;
import org.jeecg.config.JeecgCloudBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    public static final String X_PATH_VARIABLE = "x-path-variable";
    private static final String DOLLAR = "$";
    private static final String LEFT_CURLY_BRACKET = "{";

    public static boolean verifySign(SortedMap<String, String> params, String headerSign) {
        if (params == null || StringUtils.isEmpty((Object)headerSign)) {
            return false;
        }
        String paramsSign = SignUtil.getParamsSign(params);
        log.info("\u3010\u5fae\u670d\u52a1\u3011Param Sign : {}", (Object)paramsSign);
        return !StringUtils.isEmpty((Object)paramsSign) && headerSign.equals(paramsSign);
    }

    public static String getParamsSign(SortedMap<String, String> params) {
        params.remove("_t");
        String paramsJsonStr = JSONObject.toJSONString(params);
        log.info("Param paramsJsonStr : {}", (Object)paramsJsonStr);
        JeecgCloudBaseConfig jeecgBaseConfig = (JeecgCloudBaseConfig)SpringContextHolder.getBean(JeecgCloudBaseConfig.class);
        String signatureSecret = jeecgBaseConfig.getSignatureSecret();
        String curlyBracket = "${";
        if (StringUtils.isEmpty((Object)signatureSecret) || signatureSecret.contains(curlyBracket)) {
            log.error("\u3010\u5fae\u670d\u52a1\u3011\u7b7e\u540d\u5bc6\u94a5 ${jeecg.signatureSecret} \u672a\u914d\u7f6e \uff01");
            throw new JeecgCloudException("\u7b7e\u540d\u5bc6\u94a5 ${jeecg.signatureSecret} \u672a\u914d\u7f6e \uff01");
        }
        return DigestUtils.md5DigestAsHex((byte[])(paramsJsonStr + signatureSecret).getBytes()).toUpperCase();
    }
}

