/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.core.strategy.impl;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.boot.starter.lock.core.strategy.RedissonConfigStrategy;
import org.jeecg.boot.starter.lock.prop.RedissonProperties;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterslaveRedissonConfigStrategyImpl
implements RedissonConfigStrategy {
    private static final Logger log = LoggerFactory.getLogger(MasterslaveRedissonConfigStrategyImpl.class);

    @Override
    public Config createRedissonConfig(RedissonProperties redissonProperties) {
        Config config = new Config();
        try {
            String address = redissonProperties.getAddress();
            String password = redissonProperties.getPassword();
            int database = redissonProperties.getDatabase();
            String[] addrTokens = address.split(",");
            String masterNodeAddr = addrTokens[0];
            config.useMasterSlaveServers().setMasterAddress(masterNodeAddr);
            if (StringUtils.isNotBlank((CharSequence)password)) {
                config.useMasterSlaveServers().setPassword(password);
            }
            config.useMasterSlaveServers().setDatabase(database);
            ArrayList<CallSite> slaveList = new ArrayList<CallSite>();
            for (String addrToken : addrTokens) {
                slaveList.add((CallSite)((Object)("redis://" + addrToken)));
            }
            slaveList.remove(0);
            config.useMasterSlaveServers().addSlaveAddress((String[])slaveList.toArray());
            log.info("\u521d\u59cb\u5316\u4e3b\u4ece\u65b9\u5f0fConfig,redisAddress:" + address);
        }
        catch (Exception e) {
            log.error("\u4e3b\u4eceRedisson\u521d\u59cb\u5316\u9519\u8bef", (Throwable)e);
            e.printStackTrace();
        }
        return config;
    }
}

