/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.rabbitmq.client;

import cn.hutool.core.util.ObjectUtil;
import jakarta.annotation.Resource;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jeecg.boot.starter.rabbitmq.event.EventObj;
import org.jeecg.boot.starter.rabbitmq.event.JeecgRemoteApplicationEvent;
import org.jeecg.boot.starter.rabbitmq.exchange.DelayExchangeBuilder;
import org.jeecg.common.annotation.RabbitComponent;
import org.jeecg.common.base.BaseMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AbstractExchange;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqClient {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqClient.class);
    private static final Logger logger = LoggerFactory.getLogger(RabbitMqClient.class);
    private final RabbitAdmin rabbitAdmin;
    private final RabbitTemplate rabbitTemplate;
    @Resource
    private SimpleMessageListenerContainer messageListenerContainer;
    @Resource
    BusProperties busProperties;
    @Resource
    private ApplicationEventPublisher publisher;
    @Resource
    private ApplicationContext applicationContext;
    private Map sentObj = new HashMap();

    @Bean
    public void initQueue() {
        Map beansWithRqbbitComponentMap = this.applicationContext.getBeansWithAnnotation(RabbitComponent.class);
        Class<?> clazz = null;
        for (Map.Entry entry : beansWithRqbbitComponentMap.entrySet()) {
            clazz = entry.getValue().getClass();
            Method[] methods = clazz.getMethods();
            RabbitListener rabbitListener = clazz.getAnnotation(RabbitListener.class);
            if (ObjectUtil.isNotEmpty((Object)rabbitListener)) {
                log.info("\u521d\u59cb\u5316\u961f\u5217....class........rabbitListener=" + rabbitListener);
                this.createQueue(rabbitListener);
            }
            for (Method method : methods) {
                RabbitListener methodRabbitListener = method.getAnnotation(RabbitListener.class);
                if (!ObjectUtil.isNotEmpty((Object)methodRabbitListener)) continue;
                log.info("\u521d\u59cb\u5316\u961f\u5217...method.........methodRabbitListener=" + methodRabbitListener);
                this.createQueue(methodRabbitListener);
            }
        }
    }

    private void createQueue(RabbitListener rabbitListener) {
        String[] queues = rabbitListener.queues();
        DirectExchange directExchange = this.createExchange("jeecg.direct.exchange");
        this.rabbitAdmin.declareExchange((Exchange)directExchange);
        if (ObjectUtil.isNotEmpty((Object)queues)) {
            for (String queueName : queues) {
                Properties result = this.rabbitAdmin.getQueueProperties(queueName);
                if (ObjectUtil.isEmpty((Object)result)) {
                    Queue queue = new Queue(queueName);
                    this.addQueue(queue);
                    Binding binding = BindingBuilder.bind((Queue)queue).to(directExchange).with(queueName);
                    this.rabbitAdmin.declareBinding(binding);
                    log.info("\u521b\u5efa\u961f\u5217:" + queueName);
                    continue;
                }
                log.info("\u5df2\u6709\u961f\u5217:" + queueName);
            }
        }
    }

    public boolean createQueue(String queueName) {
        DirectExchange directExchange = this.createExchange("jeecg.direct.exchange");
        this.rabbitAdmin.declareExchange((Exchange)directExchange);
        Properties result = this.rabbitAdmin.getQueueProperties(queueName);
        if (ObjectUtil.isEmpty((Object)result)) {
            Queue queue = new Queue(queueName);
            this.addQueue(queue);
            Binding binding = BindingBuilder.bind((Queue)queue).to(directExchange).with(queueName);
            this.rabbitAdmin.declareBinding(binding);
            log.info("\u521b\u5efa\u961f\u5217:" + queueName);
            return true;
        }
        log.info("\u5df2\u6709\u961f\u5217:" + queueName);
        return false;
    }

    @Autowired
    public RabbitMqClient(RabbitAdmin rabbitAdmin, RabbitTemplate rabbitTemplate) {
        this.rabbitAdmin = rabbitAdmin;
        this.rabbitTemplate = rabbitTemplate;
    }

    public void publishEvent(String handlerName, BaseMap baseMap) {
        EventObj eventObj = new EventObj();
        eventObj.setHandlerName(handlerName);
        eventObj.setBaseMap(baseMap);
        this.publisher.publishEvent((ApplicationEvent)new JeecgRemoteApplicationEvent(eventObj, this.busProperties.getId()));
    }

    public Message getMessage(String messageType, Object msg) {
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType(messageType);
        Message message = new Message(msg.toString().getBytes(), messageProperties);
        return message;
    }

    public void sendMessageToExchange(TopicExchange topicExchange, String routingKey, Object msg) {
        Message message = this.getMessage("application/json", msg);
        this.rabbitTemplate.send(topicExchange.getName(), routingKey, message);
    }

    public void sendMessageToExchange(TopicExchange topicExchange, AbstractExchange exchange, String msg) {
        this.addExchange(exchange);
        logger.info("RabbitMQ send " + exchange.getName() + "->" + msg);
        this.rabbitTemplate.convertAndSend(topicExchange.getName(), (Object)msg);
    }

    public void sendMessage(String queueName, Object params) {
        log.info("\u53d1\u9001\u6d88\u606f\u5230mq");
        try {
            this.rabbitTemplate.convertAndSend("jeecg.direct.exchange", queueName, params, message -> message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(String queueName) {
        this.send(queueName, this.sentObj, 0);
        this.sentObj.clear();
    }

    public RabbitMqClient put(String key, Object value) {
        this.sentObj.put(key, value);
        return this;
    }

    public void sendMessage(String queueName, Object params, Integer expiration) {
        this.send(queueName, params, expiration);
    }

    private void send(String queueName, Object params, Integer expiration) {
        Queue queue = new Queue(queueName);
        this.addQueue(queue);
        CustomExchange customExchange = DelayExchangeBuilder.buildExchange();
        this.rabbitAdmin.declareExchange((Exchange)customExchange);
        Binding binding = BindingBuilder.bind((Queue)queue).to((Exchange)customExchange).with(queueName).noargs();
        this.rabbitAdmin.declareBinding(binding);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.debug("\u53d1\u9001\u65f6\u95f4\uff1a" + sf.format(new Date()));
        this.rabbitTemplate.convertAndSend("jeecg.delayed.exchange", queueName, params, message -> {
            if (expiration != null && expiration > 0) {
                message.getMessageProperties().setHeader("x-delay", (Object)expiration);
            }
            return message;
        });
    }

    public String receiveFromQueue(String queueName) {
        return this.receiveFromQueue(DirectExchange.DEFAULT, queueName);
    }

    public String receiveFromQueue(DirectExchange directExchange, String queueName) {
        Queue queue = new Queue(queueName);
        this.addQueue(queue);
        Binding binding = BindingBuilder.bind((Queue)queue).to(directExchange).withQueueName();
        this.rabbitAdmin.declareBinding(binding);
        String messages = (String)this.rabbitTemplate.receiveAndConvert(queueName);
        System.out.println("Receive:" + messages);
        return messages;
    }

    public void addExchange(AbstractExchange exchange) {
        this.rabbitAdmin.declareExchange((Exchange)exchange);
    }

    public boolean deleteExchange(String exchangeName) {
        return this.rabbitAdmin.deleteExchange(exchangeName);
    }

    public Queue addQueue() {
        return this.rabbitAdmin.declareQueue();
    }

    public String addQueue(Queue queue) {
        return this.rabbitAdmin.declareQueue(queue);
    }

    public void deleteQueue(String queueName, boolean unused, boolean empty) {
        this.rabbitAdmin.deleteQueue(queueName, unused, empty);
    }

    public boolean deleteQueue(String queueName) {
        return this.rabbitAdmin.deleteQueue(queueName);
    }

    public void addBinding(Queue queue, TopicExchange exchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Queue)queue).to(exchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }

    public void addBinding(Exchange exchange, TopicExchange topicExchange, String routingKey) {
        Binding binding = BindingBuilder.bind((Exchange)exchange).to(topicExchange).with(routingKey);
        this.rabbitAdmin.declareBinding(binding);
    }

    public void removeBinding(Binding binding) {
        this.rabbitAdmin.removeBinding(binding);
    }

    public DirectExchange createExchange(String exchangeName) {
        return new DirectExchange(exchangeName, true, false);
    }
}

