/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.config.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.jeecg.a.a.a;
import org.jeecg.modules.drag.util.h;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.stereotype.Component;
import org.springframework.util.ErrorHandler;

@Component(value="dragWebSocket")
@ServerEndpoint(value="/websocket/drag/{chartId}")
public class DragWebSocket {
    private static final Logger log = LoggerFactory.getLogger(DragWebSocket.class);
    private static ConcurrentHashMap<String, Session> sessionPool = new ConcurrentHashMap();
    public static final String REDIS_TOPIC_NAME = "dragSocketHandler";
    private static org.jeecg.modules.drag.config.a.a.a jmDragRedisClient;

    @Autowired
    private void setJeecgRedisClient(org.jeecg.modules.drag.config.a.a.a jmDragRedisClient) {
        DragWebSocket.jmDragRedisClient = jmDragRedisClient;
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="chartId") String chartId) {
        try {
            sessionPool.put(chartId, session);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnClose
    public void onClose(@PathParam(value="chartId") String chartId) {
        try {
            sessionPool.remove(chartId);
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception exception) {
            log.warn(exception.getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(String chartId, String message) {
        for (Map.Entry<String, Session> entry : sessionPool.entrySet()) {
            if (!entry.getKey().contains(chartId)) continue;
            Session session = entry.getValue();
            try {
                Session session2 = session;
                synchronized (session2) {
                    log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u63a8\u9001\u5355\u4eba\u6d88\u606f:" + message);
                    session.getBasicRemote().sendText(message);
                }
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @OnMessage
    public void onMessage(String message) {
        if (!"ping".equals(message) && !"heartcheck".equals(message)) {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        } else {
            log.debug("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        log.warn("\u3010\u4eea\u8868\u76d8 WebSocket\u3011\u6d88\u606f\u51fa\u73b0\u9519\u8bef");
        t.printStackTrace();
    }

    public void sendMessage(String chartId, String message) {
        a a2 = new a();
        a2.a("chartId", chartId);
        a2.a("message", message);
        jmDragRedisClient.a(REDIS_TOPIC_NAME, a2);
    }

    @Component(value="dragSocketHandler")
    class RedisSocketHandler
    implements MessageListener {
        @Autowired(required=false)
        private RedisMessageListenerContainer container;
        private final DragWebSocket dragWebSocket;

        public RedisSocketHandler(DragWebSocket dragWebSocket) {
            this.dragWebSocket = dragWebSocket;
        }

        @PostConstruct
        public void subscribeToChannel() {
            if (this.container != null) {
                this.container.addMessageListener((MessageListener)this, (Topic)new ChannelTopic("drag_redis_topic"));
                this.container.setErrorHandler(new ErrorHandler(){

                    public void handleError(Throwable t) {
                        log.warn("\u6d88\u606f\u76d1\u542c\u5668\u4e2d\u7684\u9519\u8bef: " + t.getMessage());
                    }
                });
            }
        }

        public void onMessage(Message messageObj, byte[] bytes) {
            String string = new String(messageObj.getBody(), StandardCharsets.UTF_8);
            try {
                Map map;
                Object[] objectArray;
                ObjectMapper objectMapper = new ObjectMapper();
                if (h.d(messageObj) && h.d(objectArray = (Object[])objectMapper.readValue(string, Object[].class)) && h.d(map = (Map)objectMapper.convertValue(objectArray[1], HashMap.class)) && map.containsKey("chartId")) {
                    String string2 = map.get("chartId").toString();
                    String string3 = map.get("message").toString();
                    this.dragWebSocket.pushMessage(string2, string3);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

