SELECT
<#if queryFields.valueFields ?? && (queryFields.valueFields ?size gt 0)>
   <#list queryFields.valueFields as field>
    ${field.formula}(${field.statisticaField}) ${field.alias},
   </#list>
</#if>

<#if queryFields.typeFields ?? && (queryFields.typeFields ?size gt 0)>
   <#list queryFields.typeFields as field>
      <#if field.fieldType == 'Date'>
         <#if field.type == '1'>
            date_format(${field.name}, '%Y') ${field.alias},
         <#elseif field.type == '2'>
            date_format(${field.name}, '%Y-%m') ${field.alias},
         <#elseif field.type == '3'>
            date_format(${field.name}, '%Y-%m-%d') ${field.alias},
         <#elseif field.type == '4'>
            date_format(${field.name}, '%Y-%m-%d %h') ${field.alias},
         <#else>
            date_format(${field.name}, '%Y-%m-%d %h:%i') ${field.alias},
         </#if>
      <#else>
        ${field.fieldName},
      </#if>
   </#list>
</#if>

<#if queryFields.nameFields ?? && (queryFields.nameFields ?size gt 0)>
    <#list queryFields.nameFields as field>
        <#if field.fieldType == 'Date'>
            <#if field.type == '1'>
             date_format(${field.name}, '%Y') ${field.alias}
            <#elseif field.type == '2'>
             date_format(${field.name}, '%Y-%m') ${field.alias}
            <#elseif field.type == '3'>
             date_format(${field.name}, '%Y-%m-%d') ${field.alias}
            <#elseif field.type == '4'>
             date_format(${field.name}, '%Y-%m-%d %h') ${field.alias}
            <#else>
             date_format(${field.name}, '%Y-%m-%d %h:%i') ${field.alias}
            </#if>
        <#else>
         ${field.fieldName}
        </#if>
     <#if field_has_next>
     ,
     </#if>
    </#list>
</#if>
FROM
     ${tableName}
<#if timeCondition ?? && (timeCondition ?size gt 0)>
WHERE
    ${timeCondition.timeField} between '${timeCondition.timeBegin}' and '${(timeCondition.timeEnd)}'
</#if>

<#include "OnlDragDataSourceDao_selectCondition.sql">

GROUP BY
<#if queryFields.nameFields ?? && (queryFields.nameFields ?size gt 0)>
   <#list queryFields.nameFields as field>
        <#if field.fieldType == 'Date'>
            <#if field.type == '1'>
             date_format(${field.name}, '%Y')
            <#elseif field.type == '2'>
             date_format(${field.name}, '%Y-%m')
            <#elseif field.type == '3'>
             date_format(${field.name}, '%Y-%m-%d')
            <#elseif field.type == '4'>
             date_format(${field.name}, '%Y-%m-%d %h')
            <#else>
             date_format(${field.name}, '%Y-%m-%d %h:%i')
            </#if>
        <#else>
             ${field.fieldName}
        </#if>
        <#if queryFields.typeFields ?? && (queryFields.typeFields ?size gt 0)>
           ,
        <#else>
            <#if field_has_next>
            ,
            </#if>
        </#if>
   </#list>
</#if>
<#if queryFields.typeFields ?? && (queryFields.typeFields ?size gt 0)>
   <#list queryFields.typeFields as field>
        <#if field.fieldType == 'Date'>
           <#if field.type == '1'>
            date_format(${field.name}, '%Y')
           <#elseif field.type == '2'>
            date_format(${field.name}, '%Y-%m')
           <#elseif field.type == '3'>
            date_format(${field.name}, '%Y-%m-%d')
           <#elseif field.type == '4'>
            date_format(${field.name}, '%Y-%m-%d %h')
           <#else>
            date_format(${field.name}, '%Y-%m-%d %h:%i')
           </#if>
        <#else>
             ${field.fieldName}
        </#if>
        <#if field_has_next>
             ,
        </#if>
   </#list>
</#if>

<#if queryFields.sorts ?? && queryFields.sorts.type ?? && queryFields.sorts.type ?length gt 0>
ORDER BY
    ${queryFields.sorts.field} ${queryFields.sorts.type}
</#if>

