/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.KaptExecution;
import org.jetbrains.kotlin.gradle.internal.KaptOptionsForWorker;
import org.jetbrains.kotlin.gradle.internal.KaptPathsForWorker;
import org.jetbrains.kotlin.gradle.internal.KaptTask;
import org.jetbrains.kotlin.gradle.plugin.KotlinAndroidPluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.JarSearchingUtilKt;
import org.jetbrains.kotlin.gradle.tasks.TasksUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0007R\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\r8\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00128\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u00020\r8\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000e\"\u0004\b \u0010\u0010R(\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00128\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0014\"\u0004\b#\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/KaptWithoutKotlincTask;", "Lorg/jetbrains/kotlin/gradle/internal/KaptTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "annotationProcessorFqNames", "", "", "getAnnotationProcessorFqNames", "()Ljava/util/List;", "setAnnotationProcessorFqNames", "(Ljava/util/List;)V", "isVerbose", "", "()Z", "setVerbose", "(Z)V", "javacOptions", "", "getJavacOptions", "()Ljava/util/Map;", "setJavacOptions", "(Ljava/util/Map;)V", "kaptJars", "", "Ljava/io/File;", "kaptJars$annotations", "()V", "getKaptJars", "()Ljava/util/Collection;", "mapDiagnosticLocations", "getMapDiagnosticLocations", "setMapDiagnosticLocations", "processorOptions", "getProcessorOptions", "setProcessorOptions", "compile", "", "kotlin-gradle-plugin"})
public class KaptWithoutKotlincTask
extends KaptTask {
    private boolean isVerbose;
    private boolean mapDiagnosticLocations;
    @NotNull
    public List<String> annotationProcessorFqNames;
    @NotNull
    public Map<String, String> processorOptions;
    @NotNull
    public Map<String, String> javacOptions;
    private final WorkerExecutor workerExecutor;

    public static /* synthetic */ void kaptJars$annotations() {
    }

    @InputFiles
    @Classpath
    @NotNull
    public final Collection<File> getKaptJars() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Set set = project.getConfigurations().getByName("kotlinKaptWorkerDependencies").resolve();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"project.configurations.g\u2026IGURATION_NAME).resolve()");
        return set;
    }

    @Input
    public final boolean isVerbose() {
        return this.isVerbose;
    }

    public final void setVerbose(boolean bl) {
        this.isVerbose = bl;
    }

    @Input
    public final boolean getMapDiagnosticLocations() {
        return this.mapDiagnosticLocations;
    }

    public final void setMapDiagnosticLocations(boolean bl) {
        this.mapDiagnosticLocations = bl;
    }

    @Input
    @NotNull
    public final List<String> getAnnotationProcessorFqNames() {
        List<String> list = this.annotationProcessorFqNames;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessorFqNames");
        }
        return list;
    }

    public final void setAnnotationProcessorFqNames(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.annotationProcessorFqNames = list;
    }

    @Input
    @NotNull
    public final Map<String, String> getProcessorOptions() {
        Map<String, String> map = this.processorOptions;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processorOptions");
        }
        return map;
    }

    public final void setProcessorOptions(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.processorOptions = map;
    }

    @Input
    @NotNull
    public final Map<String, String> getJavacOptions() {
        Map<String, String> map = this.javacOptions;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javacOptions");
        }
        return map;
    }

    public final void setJavacOptions(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.javacOptions = map;
    }

    @TaskAction
    public final void compile() {
        boolean bl;
        List compileClasspath;
        block7: {
            this.getLogger().info("Running kapt annotation processing using the Gradle Worker API");
            TasksUtilsKt.clearOutputDirectories$default((Task)this, null, 1, null);
            Set set = this.getClasspath().getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"classpath.files");
            compileClasspath = CollectionsKt.toMutableList((Collection)set);
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            PluginContainer pluginContainer = project.getPlugins();
            Intrinsics.checkExpressionValueIsNotNull((Object)pluginContainer, (String)"project.plugins");
            Iterable $receiver$iv = (Iterable)pluginContainer;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Plugin it = (Plugin)element$iv;
                    if (!(it instanceof KotlinAndroidPluginWrapper)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            compileClasspath.addAll(0, PathUtil.getJdkClassesRootsFromCurrentJre());
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        Set set = this.getKaptClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"kaptClasspath.files");
        KaptPathsForWorker paths = new KaptPathsForWorker(file, compileClasspath, CollectionsKt.toList((Iterable)set), CollectionsKt.toList((Iterable)this.getJavaSourceRoots()), this.getDestinationDir(), this.getClassesDir$kotlin_gradle_plugin(), this.getStubsDir$kotlin_gradle_plugin());
        List<String> list = this.annotationProcessorFqNames;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationProcessorFqNames");
        }
        Map<String, String> map = this.processorOptions;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processorOptions");
        }
        Map<String, String> map2 = this.javacOptions;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javacOptions");
        }
        KaptOptionsForWorker options = new KaptOptionsForWorker(this.isVerbose, this.mapDiagnosticLocations, list, map, map2);
        Collection<File> collection = this.getKaptJars();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        List kaptClasspath = CollectionsKt.plus(collection, (Iterable)JarSearchingUtilKt.findKotlinStdlibClasspath(project2));
        this.workerExecutor.submit(KaptExecution.class, (Action)new Action<WorkerConfiguration>(this, options, paths, kaptClasspath){
            final /* synthetic */ KaptWithoutKotlincTask this$0;
            final /* synthetic */ KaptOptionsForWorker $options;
            final /* synthetic */ KaptPathsForWorker $paths;
            final /* synthetic */ List $kaptClasspath;

            public final void execute(WorkerConfiguration config) {
                WorkerConfiguration workerConfiguration = config;
                Intrinsics.checkExpressionValueIsNotNull((Object)workerConfiguration, (String)"config");
                workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
                config.params(new Object[]{this.$options, this.$paths, JarSearchingUtilKt.findToolsJar(), this.$kaptClasspath});
                this.this$0.getLogger().info("Kapt worker classpath: " + config.getClasspath());
            }
            {
                this.this$0 = kaptWithoutKotlincTask;
                this.$options = kaptOptionsForWorker;
                this.$paths = kaptPathsForWorker;
                this.$kaptClasspath = list;
            }
        });
        this.workerExecutor.await();
    }

    @Inject
    public KaptWithoutKotlincTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }
}

