/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        ClassId classId = nameResolver.getClassId(proto.getId());
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(proto.id)");
        ClassDescriptor annotationClass = this.resolveClass(classId);
        Map arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass)) {
            Collection<ClassConstructorDescriptor> collection = annotationClass.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"annotationClass.constructors");
            ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor != null) {
                void $receiver$iv$iv;
                void $receiver$iv$iv2;
                List<ValueParameterDescriptor> list = constructor.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"constructor.valueParameters");
                Iterable $receiver$iv = list;
                int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
                Iterable iterable = $receiver$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    void v3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                    Name name = v3.getName();
                    map2.put(name, element$iv$iv);
                }
                Map parameterByName = destination$iv$iv;
                List<ProtoBuf.Annotation.Argument> list2 = proto.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.argumentList");
                Iterable capacity$iv22 = $receiver$iv = (Iterable)list2;
                Collection destination$iv$iv2 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair<Name, ConstantValue<?>> pair;
                    ProtoBuf.Annotation.Argument it;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    ProtoBuf.Annotation.Argument argument = it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)argument, (String)"it");
                    if (this.resolveArgument(argument, parameterByName, nameResolver) == null) continue;
                    Pair<Name, ConstantValue<?>> it$iv$iv = pair;
                    destination$iv$iv2.add(it$iv$iv);
                }
                arguments2 = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            }
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(nameResolver.getName(proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        Name name = nameResolver.getName(proto.getNameId());
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.type");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"proto.value");
        return new Pair((Object)name, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = new ByteValue((byte)value.getIntValue());
                break;
            }
            case 2: {
                v1 = new CharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                v1 = new ShortValue((short)value.getIntValue());
                break;
            }
            case 4: {
                v1 = new IntValue((int)value.getIntValue());
                break;
            }
            case 5: {
                v1 = new LongValue(value.getIntValue());
                break;
            }
            case 6: {
                v1 = new FloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v1 = new DoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v1 = new BooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v2 = nameResolver.getString(value.getStringValue());
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"nameResolver.getString(value.stringValue)");
                v1 = new StringValue(v2);
                break;
            }
            case 10: {
                v3 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"nameResolver.getClassId(value.classId)");
                v1 = this.resolveClassLiteralValue(v3);
                break;
            }
            case 11: {
                v4 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"nameResolver.getClassId(value.classId)");
                v5 = nameResolver.getName(value.getEnumValueId());
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"nameResolver.getName(value.enumValueId)");
                v1 = new EnumValue(v4, v5);
                break;
            }
            case 12: {
                v6 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"value.annotation");
                v1 = new AnnotationValue(this.deserializeAnnotation(v6, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                v7 = arrayElements = value.getArrayElementList();
                Intrinsics.checkExpressionValueIsNotNull(v7, (String)"arrayElements");
                var8_7 = v7;
                if (var8_7.isEmpty() == false) {
                    v8 = CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"arrayElements.first()");
                    actualElementType = this.resolveArrayElementType((ProtoBuf.Annotation.Argument.Value)v8, nameResolver);
                    v9 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v9 != null) {
                        v10 = v9;
                    } else {
                        v11 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"builtIns.getArrayType(Va\u2026RIANT, actualElementType)");
                        v10 = v11;
                    }
                } else if (expectedIsArray) {
                    v10 = expectedType;
                } else {
                    v12 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"builtIns.getArrayType(Va\u2026ARIANT, builtIns.anyType)");
                    v10 = v12;
                }
                actualArrayType = v10;
                expectedElementType = this.getBuiltIns().getArrayElementType(expectedIsArray != false ? expectedType : actualArrayType);
                var9_9 = arrayElements;
                var18_10 = ConstantValueFactory.INSTANCE;
                var10_11 = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_15 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var19_16 = destination$iv$iv;
                    v13 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"expectedElementType");
                    v14 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"it");
                    var20_17 = this.resolveValue(v13, (ProtoBuf.Annotation.Argument.Value)v14, nameResolver);
                    var19_16.add(var20_17);
                }
                var19_16 = (List)destination$iv$iv;
                v1 = var18_10.createArrayValue((List<? extends ConstantValue<?>>)var19_16, actualArrayType);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var5_5 = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ')';
                throw (Throwable)new IllegalStateException(var5_5.toString());
            }
        }
        result = v1;
        return TypeUtilsKt.isSubtypeOf(result.getType(this.module), expectedType) != false ? result : (ConstantValue)ErrorValue.Companion.create("Unexpected argument value");
    }

    private final ConstantValue<?> resolveClassLiteralValue(ClassId classId) {
        SimpleType simpleType2 = this.resolveClass(classId).getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"resolveClass(classId).defaultType");
        KotlinType starProjectedType = TypeUtilsKt.replaceArgumentsWithStarProjections((KotlinType)simpleType2);
        ClassId classId2 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.kClass.toSafe());
        Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"ClassId.topLevel(KotlinB\u2026FQ_NAMES.kClass.toSafe())");
        ClassDescriptor kClass = this.resolveClass(classId2);
        SimpleType type2 = KotlinTypeFactory.simpleNotNullType(Annotations.Companion.getEMPTY(), kClass, CollectionsKt.listOf((Object)new TypeProjectionImpl(starProjectedType)));
        return new KClassValue(type2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SimpleType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        KotlinBuiltIns kotlinBuiltIns;
        KotlinBuiltIns $receiver = kotlinBuiltIns = this.getBuiltIns();
        ProtoBuf.Annotation.Argument.Value.Type type2 = value.getType();
        if (type2 != null) {
            switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    SimpleType simpleType2 = $receiver.getByteType();
                    SimpleType simpleType3 = simpleType2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"byteType");
                    return simpleType3;
                }
                case 2: {
                    SimpleType simpleType4 = $receiver.getCharType();
                    SimpleType simpleType3 = simpleType4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"charType");
                    return simpleType3;
                }
                case 3: {
                    SimpleType simpleType5 = $receiver.getShortType();
                    SimpleType simpleType3 = simpleType5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType5, (String)"shortType");
                    return simpleType3;
                }
                case 4: {
                    SimpleType simpleType6 = $receiver.getIntType();
                    SimpleType simpleType3 = simpleType6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType6, (String)"intType");
                    return simpleType3;
                }
                case 5: {
                    SimpleType simpleType7 = $receiver.getLongType();
                    SimpleType simpleType3 = simpleType7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType7, (String)"longType");
                    return simpleType3;
                }
                case 6: {
                    SimpleType simpleType8 = $receiver.getFloatType();
                    SimpleType simpleType3 = simpleType8;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType8, (String)"floatType");
                    return simpleType3;
                }
                case 7: {
                    SimpleType simpleType9 = $receiver.getDoubleType();
                    SimpleType simpleType3 = simpleType9;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType9, (String)"doubleType");
                    return simpleType3;
                }
                case 8: {
                    SimpleType simpleType10 = $receiver.getBooleanType();
                    SimpleType simpleType3 = simpleType10;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType10, (String)"booleanType");
                    return simpleType3;
                }
                case 9: {
                    SimpleType simpleType11 = $receiver.getStringType();
                    SimpleType simpleType3 = simpleType11;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType11, (String)"stringType");
                    return simpleType3;
                }
                case 10: {
                    String string = "Arrays of class literals are not supported yet";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                case 11: {
                    ClassId classId = nameResolver.getClassId(value.getClassId());
                    Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(value.classId)");
                    SimpleType simpleType12 = this.resolveClass(classId).getDefaultType();
                    SimpleType simpleType3 = simpleType12;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType12, (String)"resolveClass(nameResolve\u2026lue.classId)).defaultType");
                    return simpleType3;
                }
                case 12: {
                    ProtoBuf.Annotation annotation = value.getAnnotation();
                    Intrinsics.checkExpressionValueIsNotNull((Object)annotation, (String)"value.annotation");
                    ClassId classId = nameResolver.getClassId(annotation.getId());
                    Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"nameResolver.getClassId(value.annotation.id)");
                    SimpleType simpleType13 = this.resolveClass(classId).getDefaultType();
                    SimpleType simpleType3 = simpleType13;
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType13, (String)"resolveClass(nameResolve\u2026notation.id)).defaultType");
                    return simpleType3;
                }
                case 13: {
                    String string = "Array of arrays is impossible";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
        String string = "Unknown type: " + value.getType();
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)notFoundClasses, (String)"notFoundClasses");
        this.module = module;
        this.notFoundClasses = notFoundClasses;
    }
}

