/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.definitions.CachingSequence;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u0004H\u0016J\b\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u001dH\u0014R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR0\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00050\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0005`\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionProvider;", "()V", "_cachedDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "cachedDefinitions", "getCachedDefinitions", "()Lkotlin/sequences/Sequence;", "currentDefinitions", "getCurrentDefinitions", "fixedDefinitions", "Ljava/util/HashMap;", "Ljava/net/URI;", "Lkotlin/collections/HashMap;", "getFixedDefinitions", "()Ljava/util/HashMap;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "clearCache", "", "findDefinition", "script", "Lkotlin/script/experimental/api/SourceCode;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "fileName", "", "getDefaultDefinition", "getDefaultScriptDefinition", "getKnownFilenameExtensions", "getScriptingHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "isScript", "", "nonScriptId", "locationId", "Companion", "kotlin-scripting-compiler-impl"})
public abstract class LazyScriptDefinitionProvider
implements ScriptDefinitionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @NotNull
    private final HashMap<URI, ScriptDefinition> fixedDefinitions = new HashMap();
    @Nullable
    private Sequence<? extends ScriptDefinition> _cachedDefinitions;
    @NotNull
    private static final String[] nonScriptFilenameSuffixes;

    @NotNull
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    @NotNull
    protected abstract Sequence<ScriptDefinition> getCurrentDefinitions();

    @NotNull
    protected ScriptingHostConfiguration getScriptingHostConfiguration() {
        return JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration();
    }

    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        return ScriptDefinition.Companion.getDefault(this.getScriptingHostConfiguration());
    }

    @NotNull
    protected final HashMap<URI, ScriptDefinition> getFixedDefinitions() {
        return this.fixedDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Sequence<ScriptDefinition> getCachedDefinitions() {
        boolean bl = this.lock.getReadLockCount() > 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "cachedDefinitions should only be used under the read lock";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this._cachedDefinitions == null) {
            int n;
            int n2;
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            bl2 = false;
            boolean bl4 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl5 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl6 = false;
                this._cachedDefinitions = new CachingSequence(SequencesKt.constrainOnce(this.getCurrentDefinitions()));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl7 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
        Sequence<? extends ScriptDefinition> sequence = this._cachedDefinitions;
        Intrinsics.checkNotNull(sequence);
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearCache() {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            this._cachedDefinitions = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    protected boolean nonScriptId(@NotNull String locationId) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)locationId, (String)"locationId");
            String[] $this$any$iv = nonScriptFilenameSuffixes;
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!StringsKt.endsWith((String)locationId, (String)it, (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (script.getLocationId() == null) return null;
        Object object = script.getLocationId();
        Intrinsics.checkNotNull((Object)object);
        if (this.nonScriptId((String)object)) {
            return null;
        }
        object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        readLock.lock();
        try {
            Object v0;
            block5: {
                boolean bl3 = false;
                Sequence<ScriptDefinition> $this$firstOrNull$iv = this.getCachedDefinitions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                    boolean bl4 = false;
                    if (!it.isScript(script)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            ScriptDefinition scriptDefinition = v0;
            ScriptDefinition scriptDefinition2 = scriptDefinition;
            return scriptDefinition2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public KotlinScriptDefinition findScriptDefinition(@NotNull String fileName) {
        KotlinScriptDefinition kotlinScriptDefinition;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (this.nonScriptId(fileName)) {
            kotlinScriptDefinition = null;
        } else {
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                Object v1;
                block6: {
                    boolean bl3 = false;
                    Sequence $this$firstOrNull$iv = SequencesKt.map(this.getCachedDefinitions(), (Function1)findScriptDefinition.1.1.INSTANCE);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KotlinScriptDefinition it = (KotlinScriptDefinition)((Object)element$iv);
                        boolean bl4 = false;
                        if (!it.isScript(fileName)) continue;
                        v1 = element$iv;
                        break block6;
                    }
                    v1 = null;
                }
                KotlinScriptDefinition kotlinScriptDefinition2 = v1;
                kotlinScriptDefinition = kotlinScriptDefinition2;
            }
            finally {
                readLock.unlock();
            }
        }
        return kotlinScriptDefinition;
    }

    @Override
    public boolean isScript(@NotNull SourceCode script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.findDefinition(script) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Sequence<String> getKnownFilenameExtensions() {
        Sequence sequence;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            sequence = SequencesKt.map(this.getCachedDefinitions(), (Function1)getKnownFilenameExtensions.1.1.INSTANCE);
        }
        finally {
            readLock.unlock();
        }
        return sequence;
    }

    @Override
    @NotNull
    public KotlinScriptDefinition getDefaultScriptDefinition() {
        return this.getDefaultDefinition().getLegacyDefinition();
    }

    static {
        String[] stringArray = new String[]{".kt", ".java"};
        nonScriptFilenameSuffixes = stringArray;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider$Companion;", "", "()V", "nonScriptFilenameSuffixes", "", "", "getNonScriptFilenameSuffixes", "()[Ljava/lang/String;", "[Ljava/lang/String;", "kotlin-scripting-compiler-impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final String[] getNonScriptFilenameSuffixes() {
            return nonScriptFilenameSuffixes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

