/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.ReadBuffer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B&\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r0\f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001b\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrMultiTableReader;", "K", "", "buffer", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "keyReader", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/library/impl/ReadBuffer;Lkotlin/jvm/functions/Function1;)V", "indexToIndexMap", "", "", "", "Lkotlin/Pair;", "indexToOffset", "", "readIndexMap", "position", "readOffsets", "tableItemBytes", "", "row", "id", "(ILjava/lang/Object;)[B", "kotlin-util-klib"})
public abstract class IrMultiTableReader<K> {
    @NotNull
    private final ReadBuffer buffer;
    @NotNull
    private final Function1<ReadBuffer, K> keyReader;
    @NotNull
    private final int[] indexToOffset;
    @NotNull
    private final Map<Integer, Map<K, Pair<Integer, Integer>>> indexToIndexMap;

    public IrMultiTableReader(@NotNull ReadBuffer buffer, @NotNull Function1<? super ReadBuffer, ? extends K> keyReader) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(keyReader, (String)"keyReader");
        this.buffer = buffer;
        this.keyReader = keyReader;
        boolean bl = false;
        this.indexToIndexMap = new LinkedHashMap();
        this.indexToOffset = this.readOffsets(0);
    }

    private final int[] readOffsets(int position) {
        this.buffer.setPosition(position);
        int count = this.buffer.getInt();
        int[] result = new int[count + 1];
        result[0] = 4 * (count + 1);
        int n = 0;
        if (n < count) {
            do {
                int i = n++;
                int size = this.buffer.getInt();
                result[i + 1] = result[i] + size;
            } while (n < count);
        }
        return result;
    }

    private final Map<K, Pair<Integer, Integer>> readIndexMap(int position) {
        this.buffer.setPosition(position);
        boolean bl = false;
        Map result = new LinkedHashMap();
        int count = this.buffer.getInt();
        int n = 0;
        if (n < count) {
            do {
                int i = n++;
                Object key = this.keyReader.invoke((Object)this.buffer);
                int offset = this.buffer.getInt();
                int size = this.buffer.getInt();
                Map map = result;
                Pair pair = TuplesKt.to((Object)offset, (Object)size);
                boolean bl2 = false;
                map.put(key, pair);
            } while (n < count);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] tableItemBytes(int row, K id) {
        Map indexToMap;
        Object object;
        void $this$getOrPut$iv;
        int rowOffset = this.indexToOffset[row];
        Map<Integer, Map<K, Pair<Integer, Integer>>> map = this.indexToIndexMap;
        Integer key$iv = row;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(key$iv);
        if (value$iv2 == null) {
            boolean bl = false;
            Map<K, Pair<Integer, Integer>> answer$iv = this.readIndexMap(rowOffset);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        if ((key$iv = (Pair)(indexToMap = (Map)object).get(id)) == null) {
            String $i$f$getOrPut2 = Intrinsics.stringPlus((String)"No coordinates found for ", id);
            boolean value$iv2 = false;
            throw (Throwable)new IllegalStateException($i$f$getOrPut2.toString());
        }
        Integer coordinates = key$iv;
        int offset = ((Number)coordinates.getFirst()).intValue();
        int size = ((Number)coordinates.getSecond()).intValue();
        byte[] result = new byte[size];
        this.buffer.setPosition(rowOffset + offset);
        this.buffer.get(result, 0, size);
        return result;
    }
}

