/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.specifics;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.specifics.DirectedEdgeContainer;
import org.jgrapht.graph.specifics.DirectedSpecifics;
import org.jgrapht.util.ArrayUnenforcedSet;
import org.jgrapht.util.VertexPair;

public class FastLookupDirectedSpecifics<V, E>
extends DirectedSpecifics<V, E>
implements Serializable {
    private static final long serialVersionUID = 4089085208843722263L;
    protected Map<VertexPair<V>, ArrayUnenforcedSet<E>> touchingVerticesToEdgeMap = new HashMap<VertexPair<V>, ArrayUnenforcedSet<E>>();

    public FastLookupDirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph) {
        this(abstractBaseGraph, new LinkedHashMap());
    }

    public FastLookupDirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, DirectedEdgeContainer<V, E>> vertexMap) {
        super(abstractBaseGraph, vertexMap);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        if (this.abstractBaseGraph.containsVertex(sourceVertex) && this.abstractBaseGraph.containsVertex(targetVertex)) {
            Set edges = this.touchingVerticesToEdgeMap.get(new VertexPair<V>(sourceVertex, targetVertex));
            return edges == null ? Collections.emptySet() : new ArrayUnenforcedSet(edges);
        }
        return null;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        List edges = this.touchingVerticesToEdgeMap.get(new VertexPair<V>(sourceVertex, targetVertex));
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.get(0);
    }

    @Override
    public void addEdgeToTouchingVertices(E e) {
        Object source = this.abstractBaseGraph.getEdgeSource(e);
        Object target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).addOutgoingEdge(e);
        this.getEdgeContainer(target).addIncomingEdge(e);
        VertexPair vertexPair = new VertexPair(source, target);
        if (!this.touchingVerticesToEdgeMap.containsKey(vertexPair)) {
            ArrayUnenforcedSet<E> edgeSet = new ArrayUnenforcedSet<E>();
            edgeSet.add(e);
            this.touchingVerticesToEdgeMap.put(vertexPair, edgeSet);
        } else {
            this.touchingVerticesToEdgeMap.get(vertexPair).add(e);
        }
    }

    @Override
    public void removeEdgeFromTouchingVertices(E e) {
        Object source = this.abstractBaseGraph.getEdgeSource(e);
        Object target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).removeOutgoingEdge(e);
        this.getEdgeContainer(target).removeIncomingEdge(e);
        VertexPair vertexPair = new VertexPair(source, target);
        if (this.touchingVerticesToEdgeMap.containsKey(vertexPair)) {
            ArrayUnenforcedSet<E> edgeSet = this.touchingVerticesToEdgeMap.get(vertexPair);
            edgeSet.remove(e);
            if (edgeSet.isEmpty()) {
                this.touchingVerticesToEdgeMap.remove(vertexPair);
            }
        }
    }
}

