/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.templating.expressions.operands;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.Operand;

public enum InternalOperandTypeForCalculations {
    DECIMAL(Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE),
    FLOAT(Float.class, Float.TYPE, Double.class, Double.TYPE),
    BOOLEAN(Boolean.class, Boolean.TYPE),
    STRING(String.class),
    OBJECT(new Class[0]);

    private final Class[] supportedTypes;

    private InternalOperandTypeForCalculations(Class ... supportedTypes) {
        this.supportedTypes = supportedTypes;
    }

    public Class[] getSupportedTypes() {
        return this.supportedTypes;
    }

    public boolean isSupportedType(Class type) {
        if (type == null) {
            return false;
        }
        return InternalOperandTypeForCalculations.getSupportedOperandModeClasses(this).contains(type);
    }

    public static Set<Class> getSupportedOperandModeClasses(InternalOperandTypeForCalculations ... internalOperandTypeForCalculations) {
        HashSet<Class> set = new HashSet<Class>();
        if (internalOperandTypeForCalculations != null) {
            for (InternalOperandTypeForCalculations internalOperandTypeForCalculation : internalOperandTypeForCalculations) {
                set.addAll(Arrays.asList(internalOperandTypeForCalculation.getSupportedTypes()));
            }
        }
        return set;
    }

    public static InternalOperandTypeForCalculations getOperationModeForOperand(Operand operand) {
        if (operand != null) {
            for (InternalOperandTypeForCalculations internalOperandTypeForCalculations : InternalOperandTypeForCalculations.values()) {
                if (!internalOperandTypeForCalculations.isSupportedType(operand.getOperandsJavaType())) continue;
                return internalOperandTypeForCalculations;
            }
        }
        return OBJECT;
    }
}

