/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.tools.generators;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.jmolecules.annotation.processor.aptk.common.ToolingProvider;
import org.jmolecules.annotation.processor.aptk.tools.generators.SimpleWriter;

public class SimpleKotlinWriter
extends SimpleWriter {
    static final String KAPT_KOTLIN_GENERATED = "kapt.kotlin.generated";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("(\\w+?(?:[.]\\w+?)*)[.]\\w*");
    private static final Pattern CLASSNAME_PATTERN = Pattern.compile("(?:\\w+?[.])*(\\w*)");
    private final String fqn;
    private final Element[] originatingElements;
    private final String kaptKotlinGeneratedDirectory;
    private File targetFile;

    public SimpleKotlinWriter(String fqn, Element ... originatingElements) {
        this.fqn = fqn;
        this.originatingElements = originatingElements;
        ToolingProvider toolingProvider = ToolingProvider.getTooling();
        this.kaptKotlinGeneratedDirectory = toolingProvider.getProcessingEnvironment().getOptions().get(KAPT_KOTLIN_GENERATED);
        if (this.kaptKotlinGeneratedDirectory == null) {
            toolingProvider.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot determine kotlin generated folder: Please make sure that KAPT plugin is configured properly ", this.originatingElements != null && this.originatingElements.length >= 1 ? this.originatingElements[0] : null);
        } else {
            File targetPackageDir = this.createTargetPackageDirectory();
            this.targetFile = new File(targetPackageDir, SimpleKotlinWriter.getClassNameFromFqn(fqn) + ".kt");
        }
    }

    @Override
    public void append(String content) throws IOException {
        if (this.kaptKotlinGeneratedDirectory == null) {
            return;
        }
        Files.write(this.targetFile.toPath(), content.getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    @Override
    public void write(char[] buffer) throws IOException {
        if (this.kaptKotlinGeneratedDirectory == null) {
            return;
        }
        byte[] byteBuffer = new String(buffer).getBytes(StandardCharsets.UTF_8);
        Files.write(this.targetFile.toPath(), byteBuffer, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public void write(String content) throws IOException {
        if (this.kaptKotlinGeneratedDirectory == null) {
            return;
        }
        Files.write(this.targetFile.toPath(), content.getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private void createFile() throws IOException {
        Files.createFile(this.targetFile.toPath(), new FileAttribute[0]);
    }

    @Override
    public void close() throws IOException {
    }

    private File createTargetPackageDirectory() {
        File targetPackageDirectory = this.getTargetPackageDirectoryFile();
        if (!targetPackageDirectory.exists()) {
            targetPackageDirectory.mkdirs();
        }
        return targetPackageDirectory;
    }

    static String getPackageFromFqn(String fqn) {
        Matcher matcher = PACKAGE_PATTERN.matcher(fqn);
        return matcher.matches() ? matcher.group(1) : "";
    }

    static String getClassNameFromFqn(String fqn) {
        Matcher matcher = CLASSNAME_PATTERN.matcher(fqn);
        return matcher.matches() ? matcher.group(1) : fqn;
    }

    File getTargetPackageDirectoryFile() {
        return new File(this.kaptKotlinGeneratedDirectory + File.separator + SimpleKotlinWriter.getPackageFromFqn(this.fqn).replaceAll("[.]", File.separator));
    }

    public File getTargetFile() {
        return this.targetFile;
    }
}

