/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.job.AbstractTargetDocumentSpecs;
import org.jodconverter.core.job.DocumentSpecsIOException;
import org.jodconverter.core.job.TargetDocumentSpecs;
import org.jodconverter.core.office.TemporaryFileMaker;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.core.util.FileUtils;

public class TargetDocumentSpecsFromOutputStream
extends AbstractTargetDocumentSpecs
implements TargetDocumentSpecs {
    private final OutputStream outputStream;
    private final boolean closeStream;
    private final TemporaryFileMaker fileMaker;

    public TargetDocumentSpecsFromOutputStream(@NonNull OutputStream outputStream, @NonNull TemporaryFileMaker fileMaker, boolean closeStream) {
        AssertUtils.notNull(outputStream, "outputStream must not be null");
        AssertUtils.notNull(fileMaker, "fileMaker must not be null");
        this.outputStream = outputStream;
        this.closeStream = closeStream;
        this.fileMaker = fileMaker;
    }

    @Override
    public @NonNull File getFile() {
        return Optional.ofNullable(this.getFormat()).map(format -> this.fileMaker.makeTemporaryFile(format.getExtension())).orElse(this.fileMaker.makeTemporaryFile());
    }

    @Override
    public void onComplete(@NonNull File tempFile) {
        try {
            Files.copy(tempFile.toPath(), this.outputStream);
            if (this.closeStream) {
                this.outputStream.close();
            }
        }
        catch (IOException ex) {
            throw new DocumentSpecsIOException(String.format("Could not write file '%s' to stream", tempFile), ex);
        }
        finally {
            FileUtils.deleteQuietly(tempFile);
        }
    }
}

