/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import java.io.File;
import java.io.OutputStream;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.job.AbstractConversionJob;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.AbstractTargetDocumentSpecs;
import org.jodconverter.core.job.ConversionJobWithOptionalSourceFormatUnspecified;
import org.jodconverter.core.job.TargetDocumentSpecsFromFile;
import org.jodconverter.core.job.TargetDocumentSpecsFromOutputStream;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.TemporaryFileMaker;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.core.util.FileUtils;

public abstract class AbstractConversionJobWithSourceFormatUnspecified
implements ConversionJobWithOptionalSourceFormatUnspecified {
    private static final boolean DEFAULT_CLOSE_STREAM = true;
    protected final AbstractSourceDocumentSpecs source;
    protected final OfficeManager officeManager;
    protected final DocumentFormatRegistry formatRegistry;

    protected AbstractConversionJobWithSourceFormatUnspecified(@NonNull AbstractSourceDocumentSpecs source, @NonNull OfficeManager officeManager, @NonNull DocumentFormatRegistry formatRegistry) {
        AssertUtils.notNull(source, "source must not be null");
        AssertUtils.notNull(officeManager, "officeManager must not be null");
        AssertUtils.notNull(formatRegistry, "formatRegistry must not be null");
        this.source = source;
        this.officeManager = officeManager;
        this.formatRegistry = formatRegistry;
    }

    @Override
    public @NonNull AbstractConversionJobWithSourceFormatUnspecified as(@NonNull DocumentFormat format) {
        this.source.setDocumentFormat(format);
        return this;
    }

    @Override
    public @NonNull AbstractConversionJob to(@NonNull File target) {
        TargetDocumentSpecsFromFile specs = new TargetDocumentSpecsFromFile(target);
        DocumentFormat format = this.formatRegistry.getFormatByExtension(Objects.requireNonNull(FileUtils.getExtension(target.getName())));
        if (format != null) {
            specs.setDocumentFormat(format);
        }
        return this.toInternal(specs);
    }

    @Override
    public @NonNull AbstractConversionJob to(@NonNull OutputStream target) {
        return this.to(target, true);
    }

    @Override
    public @NonNull AbstractConversionJob to(@NonNull OutputStream target, boolean closeStream) {
        if (this.officeManager instanceof TemporaryFileMaker) {
            return this.toInternal(new TargetDocumentSpecsFromOutputStream(target, (TemporaryFileMaker)((Object)this.officeManager), closeStream));
        }
        throw new IllegalStateException("An office manager must implements the TemporaryFileMaker interface in order to be able to convert to OutputStream");
    }

    protected abstract @NonNull AbstractConversionJob to(@NonNull AbstractTargetDocumentSpecs var1);

    private AbstractConversionJob toInternal(AbstractTargetDocumentSpecs target) {
        return this.to(target);
    }
}

