/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.CallableStatement;
import java.sql.SQLException;
import jodd.db.DbQueryParser;
import jodd.db.DbSqlException;

public class DbCallResult {
    private final DbQueryParser query;
    private final CallableStatement statement;

    DbCallResult(DbQueryParser parser, CallableStatement callableStatement) {
        this.query = parser;
        this.statement = callableStatement;
    }

    public int getInteger(int index) {
        try {
            return this.statement.getInt(index);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(index, (Exception)sex);
        }
    }

    public int getInteger(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        try {
            if (positions.length == 1) {
                return this.statement.getInt(positions[0]);
            }
            throw this.newGetParamError(param);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public int[] getAllInteger(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        int[] result = new int[positions.length];
        try {
            for (int i = 0; i < positions.length; ++i) {
                result[i] = this.statement.getInt(positions[i]);
            }
            return result;
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public boolean getBoolean(int index) {
        try {
            return this.statement.getBoolean(index);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(index, (Exception)sex);
        }
    }

    public boolean getBoolean(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        try {
            if (positions.length == 1) {
                return this.statement.getBoolean(positions[0]);
            }
            throw this.newGetParamError(param);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public boolean[] getAllBoolean(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        boolean[] result = new boolean[positions.length];
        try {
            for (int i = 0; i < positions.length; ++i) {
                result[i] = this.statement.getBoolean(positions[i]);
            }
            return result;
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public byte getByte(int index) {
        try {
            return this.statement.getByte(index);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(index, (Exception)sex);
        }
    }

    public byte getByte(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        try {
            if (positions.length == 1) {
                return this.statement.getByte(positions[0]);
            }
            throw this.newGetParamError(param);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public byte[] getAllByte(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        byte[] result = new byte[positions.length];
        try {
            for (int i = 0; i < positions.length; ++i) {
                result[i] = this.statement.getByte(positions[i]);
            }
            return result;
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public double getDouble(int index) {
        try {
            return this.statement.getDouble(index);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(index, (Exception)sex);
        }
    }

    public double getDouble(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        try {
            if (positions.length == 1) {
                return this.statement.getDouble(positions[0]);
            }
            throw this.newGetParamError(param);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public double[] getAllDouble(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        double[] result = new double[positions.length];
        try {
            for (int i = 0; i < positions.length; ++i) {
                result[i] = this.statement.getDouble(positions[i]);
            }
            return result;
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public float getFloat(int index) {
        try {
            return this.statement.getFloat(index);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(index, (Exception)sex);
        }
    }

    public float getFloat(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        try {
            if (positions.length == 1) {
                return this.statement.getFloat(positions[0]);
            }
            throw this.newGetParamError(param);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public float[] getAllFloat(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        float[] result = new float[positions.length];
        try {
            for (int i = 0; i < positions.length; ++i) {
                result[i] = this.statement.getFloat(positions[i]);
            }
            return result;
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public String getString(int index) {
        try {
            return this.statement.getString(index);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(index, (Exception)sex);
        }
    }

    public String getString(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        try {
            if (positions.length == 1) {
                return this.statement.getString(positions[0]);
            }
            throw this.newGetParamError(param);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public String[] getAllString(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        String[] result = new String[positions.length];
        try {
            for (int i = 0; i < positions.length; ++i) {
                result[i] = this.statement.getString(positions[i]);
            }
            return result;
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public long getLong(int index) {
        try {
            return this.statement.getLong(index);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(index, (Exception)sex);
        }
    }

    public long getLong(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        try {
            if (positions.length == 1) {
                return this.statement.getLong(positions[0]);
            }
            throw this.newGetParamError(param);
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    public long[] getAllLong(String param) {
        int[] positions = this.query.getNamedParameterIndices(param);
        long[] result = new long[positions.length];
        try {
            for (int i = 0; i < positions.length; ++i) {
                result[i] = this.statement.getLong(positions[i]);
            }
            return result;
        }
        catch (SQLException sex) {
            throw this.newGetParamError(param, (Exception)sex);
        }
    }

    private DbSqlException newGetParamError(int index, Exception ex) {
        return new DbSqlException("Invalid SQL parameter with index: " + index, ex);
    }

    private DbSqlException newGetParamError(String param, Exception ex) {
        return new DbSqlException("Invalid SQL parameter with name: " + param, ex);
    }

    private DbSqlException newGetParamError(String param) {
        return new DbSqlException("Invalid number of parameter with name: " + param);
    }
}

