/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import jodd.introspector.ClassIntrospector;
import jodd.json.JsonSerializer;
import jodd.json.JsonValueContext;
import jodd.json.JsonWriter;
import jodd.json.Path;
import jodd.json.TypeJsonSerializer;
import jodd.json.TypeJsonSerializerMap;
import jodd.util.ClassUtil;
import jodd.util.Wildcard;

public class JsonContext
extends JsonWriter {
    protected final JsonSerializer jsonSerializer;
    protected final List<JsonValueContext> bag;
    protected int bagSize = 0;
    protected final Path path;
    protected final boolean excludeNulls;
    protected final boolean excludeEmpty;
    protected final Function<Object, TypeJsonSerializer> serializerResolver;
    protected JsonValueContext lastValueContext = null;

    public JsonContext(JsonSerializer jsonSerializer, Appendable appendable) {
        super(appendable, jsonSerializer.strictStringEncoding);
        this.jsonSerializer = jsonSerializer;
        this.bag = new ArrayList<JsonValueContext>();
        this.path = new Path();
        this.excludeNulls = jsonSerializer.excludeNulls;
        this.excludeEmpty = jsonSerializer.excludeEmpty;
        this.serializerResolver = jsonSerializer.serializerResolver;
    }

    public JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    public boolean isExcludeNulls() {
        return this.excludeNulls;
    }

    public boolean isExcludeEmpty() {
        return this.excludeEmpty;
    }

    public boolean pushValue(Object value) {
        for (int i = 0; i < this.bagSize; ++i) {
            JsonValueContext valueContext = this.bag.get(i);
            if (valueContext.getValue() != value) continue;
            return true;
        }
        if (this.bagSize == this.bag.size()) {
            this.lastValueContext = new JsonValueContext(value);
            this.bag.add(this.lastValueContext);
        } else {
            this.lastValueContext = this.bag.get(this.bagSize);
            this.lastValueContext.reuse(value);
        }
        ++this.bagSize;
        return false;
    }

    public void popValue() {
        --this.bagSize;
        this.lastValueContext = this.bagSize == 0 ? null : this.bag.get(this.bagSize - 1);
    }

    public JsonValueContext peekValueContext() {
        return this.lastValueContext;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void pushName(String name, boolean withComma) {
        JsonValueContext valueContext = this.peekValueContext();
        if (valueContext != null) {
            valueContext.setPropertyName(name);
        }
        super.pushName(name, withComma);
    }

    @Override
    public void writeComma() {
        JsonValueContext valueContext = this.peekValueContext();
        if (valueContext != null) {
            valueContext.incrementIndex();
        }
        super.writeComma();
    }

    public boolean serialize(Object object) {
        if (object == null) {
            this.write("null");
            return true;
        }
        TypeJsonSerializer typeJsonSerializer = null;
        if (this.serializerResolver != null) {
            typeJsonSerializer = this.serializerResolver.apply(object);
        }
        if (typeJsonSerializer == null) {
            if (this.jsonSerializer.pathSerializersMap != null) {
                typeJsonSerializer = this.jsonSerializer.pathSerializersMap.get(this.path);
            }
            Class<?> type = object.getClass();
            if (this.jsonSerializer.typeSerializersMap != null) {
                typeJsonSerializer = this.jsonSerializer.typeSerializersMap.lookup(type);
            }
            if (typeJsonSerializer == null) {
                typeJsonSerializer = TypeJsonSerializerMap.get().lookup(type);
            }
        }
        return typeJsonSerializer.serialize(this, object);
    }

    public boolean matchIgnoredPropertyTypes(Class propertyType, boolean excludeMaps, boolean include) {
        if (!include) {
            return false;
        }
        if (propertyType != null) {
            if (!this.jsonSerializer.deep) {
                Class[] propertyTypeClassDescriptor = ClassIntrospector.get().lookup(propertyType);
                if (propertyTypeClassDescriptor.isArray()) {
                    return false;
                }
                if (propertyTypeClassDescriptor.isCollection()) {
                    return false;
                }
                if (excludeMaps && propertyTypeClassDescriptor.isMap()) {
                    return false;
                }
            }
            if (this.jsonSerializer.excludedTypes != null) {
                for (Class excludedType : this.jsonSerializer.excludedTypes) {
                    if (!ClassUtil.isTypeOf(propertyType, excludedType)) continue;
                    return false;
                }
            }
            String propertyTypeName = propertyType.getName();
            if (this.jsonSerializer.excludedTypeNames != null) {
                for (String excludedTypeName : this.jsonSerializer.excludedTypeNames) {
                    if (!Wildcard.match(propertyTypeName, excludedTypeName)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean matchPathToQueries(boolean include) {
        return this.jsonSerializer.rules.apply(this.path, include);
    }
}

