/*
 * Decompiled with CFR 0.152.
 */
package jodd.json.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jodd.cache.TypeCache;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.json.meta.JSON;
import jodd.json.meta.JSONAnnotationValues;
import jodd.json.meta.TypeData;
import jodd.util.annotation.AnnotationParser;

public class JsonAnnotationManager {
    private static final JsonAnnotationManager JSON_ANNOTATION_MANAGER = new JsonAnnotationManager();
    private final TypeCache<TypeData> typeDataMap = TypeCache.createDefault();
    private boolean serializationSubclassAware;
    private Class<? extends Annotation> jsonAnnotation;

    public static JsonAnnotationManager get() {
        return JSON_ANNOTATION_MANAGER;
    }

    public JsonAnnotationManager() {
        this.reset();
    }

    public TypeData lookupTypeData(Class type) {
        TypeData typeData = this.typeDataMap.get(type);
        if (typeData == null) {
            if (this.serializationSubclassAware) {
                typeData = this.findSubclassTypeData(type);
            }
            if (typeData == null) {
                typeData = this.scanClassForAnnotations(type);
                this.typeDataMap.put(type, typeData);
            }
        }
        return typeData;
    }

    protected TypeData _lookupTypeData(Class type) {
        TypeData typeData = this.typeDataMap.get(type);
        if (typeData == null) {
            typeData = this.scanClassForAnnotations(type);
            this.typeDataMap.put(type, typeData);
        }
        return typeData;
    }

    protected TypeData findSubclassTypeData(Class type) {
        Class[] interfaces;
        Class[] superClasses;
        Class<? extends Annotation> defaultAnnotation = this.jsonAnnotation;
        if (type.getAnnotation(defaultAnnotation) != null) {
            return null;
        }
        ClassDescriptor cd = ClassIntrospector.get().lookup(type);
        for (Class superClass : superClasses = cd.getAllSuperclasses()) {
            if (superClass.getAnnotation(defaultAnnotation) == null) continue;
            return this._lookupTypeData(superClass);
        }
        for (Class interfaze : interfaces = cd.getAllInterfaces()) {
            if (interfaze.getAnnotation(defaultAnnotation) == null) continue;
            return this._lookupTypeData(interfaze);
        }
        return null;
    }

    public String resolveJsonName(Class type, String name) {
        TypeData typeData = this.lookupTypeData(type);
        return typeData.resolveJsonName(name);
    }

    public String resolveRealName(Class type, String jsonName) {
        TypeData typeData = this.lookupTypeData(type);
        return typeData.resolveRealName(jsonName);
    }

    private TypeData scanClassForAnnotations(Class type) {
        JSONAnnotationValues data;
        ClassDescriptor cd = ClassIntrospector.get().lookup(type);
        PropertyDescriptor[] pds = cd.getAllPropertyDescriptors();
        ArrayList<String> includedList = new ArrayList<String>();
        ArrayList<String> excludedList = new ArrayList<String>();
        ArrayList<String> jsonNames = new ArrayList<String>();
        ArrayList<String> realNames = new ArrayList<String>();
        AnnotationParser annotationParser = JSONAnnotationValues.parserFor(this.jsonAnnotation);
        for (PropertyDescriptor pd : pds) {
            FieldDescriptor fd;
            Method method;
            JSONAnnotationValues data2 = null;
            MethodDescriptor md = pd.getReadMethodDescriptor();
            if (md != null) {
                method = md.getMethod();
                data2 = JSONAnnotationValues.of(annotationParser, method);
            }
            if (data2 == null && (md = pd.getWriteMethodDescriptor()) != null) {
                method = md.getMethod();
                data2 = JSONAnnotationValues.of(annotationParser, method);
            }
            if (data2 == null && (fd = pd.getFieldDescriptor()) != null) {
                Field field = fd.getField();
                data2 = JSONAnnotationValues.of(annotationParser, field);
            }
            if (data2 == null) continue;
            String propertyName = pd.getName();
            String newPropertyName = data2.name();
            if (newPropertyName != null) {
                realNames.add(propertyName);
                jsonNames.add(newPropertyName);
                propertyName = newPropertyName;
            }
            if (data2.include()) {
                includedList.add(propertyName);
                continue;
            }
            excludedList.add(propertyName);
        }
        String[] reals = null;
        if (!realNames.isEmpty()) {
            reals = realNames.toArray(new String[0]);
        }
        String[] jsons = null;
        if (!jsonNames.isEmpty()) {
            jsons = jsonNames.toArray(new String[0]);
        }
        return new TypeData(includedList, excludedList, (data = JSONAnnotationValues.of(annotationParser, type)) != null && data.strict(), jsons, reals);
    }

    public JsonAnnotationManager setSerializationSubclassAware(boolean serializationSubclassAware) {
        this.serializationSubclassAware = serializationSubclassAware;
        return this;
    }

    public JsonAnnotationManager setJsonAnnotation(Class<? extends Annotation> jsonAnnotation) {
        this.jsonAnnotation = jsonAnnotation;
        return this;
    }

    public void reset() {
        this.typeDataMap.clear();
        this.serializationSubclassAware = true;
        this.jsonAnnotation = JSON.class;
    }
}

