/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.io.Closeable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jodd.io.StreamUtil;
import jodd.json.JsonSerializer;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.component.MadvocEncoding;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.scope.MadvocContext;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.JsonResult;

public class JsonActionResult
implements ActionResult {
    @In
    @MadvocContext
    protected MadvocEncoding madvocEncoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(ActionRequest actionRequest, Object resultValue) throws Exception {
        int status;
        String json;
        HttpServletResponse response = actionRequest.getHttpServletResponse();
        String encoding = response.getCharacterEncoding();
        if (encoding == null) {
            encoding = this.madvocEncoding.getEncoding();
        }
        response.setContentType("application/json");
        response.setCharacterEncoding(encoding);
        if (resultValue instanceof JsonResult) {
            JsonResult jsonResult = (JsonResult)resultValue;
            json = jsonResult.value();
            status = jsonResult.status();
            String statusMessage = jsonResult.message();
        } else {
            json = JsonSerializer.create().deep(true).serialize(resultValue);
            status = 200;
            String statusMessage = "OK";
        }
        response.setStatus(status);
        byte[] data = json.getBytes(encoding);
        response.setContentLength(data.length);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(data);
        }
        finally {
            StreamUtil.close((Closeable)out);
        }
    }
}

