/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.util.function.Consumer;
import jodd.methref.Methref;

public abstract class PathResult {
    private final String path;
    private final Class target;
    private final Methref methref;

    public PathResult(String path) {
        this.path = path;
        this.methref = null;
        this.target = null;
    }

    public <T> PathResult(Class<T> target, Consumer<T> consumer) {
        this.path = null;
        Methref<T> methref = this.wrapTargetToMethref(target);
        consumer.accept(methref.to());
        this.methref = methref;
        this.target = target;
    }

    protected <T> Methref<T> wrapTargetToMethref(Class<T> target) {
        return Methref.on(target);
    }

    public String path() {
        if (this.methref != null) {
            String methodName = this.methref.ref();
            return this.target.getName() + '#' + methodName;
        }
        return this.path;
    }
}

