/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jodd.asm.TraceSignatureVisitor;
import jodd.asm6.signature.SignatureReader;

public class GenericsReader {
    public Map<String, String> parseSignatureForGenerics(String signature, boolean isInterface) {
        if (signature == null) {
            return Collections.emptyMap();
        }
        final HashMap<String, String> genericsMap = new HashMap<String, String>();
        SignatureReader sr = new SignatureReader(signature);
        StringBuilder sb = new StringBuilder();
        TraceSignatureVisitor v = new TraceSignatureVisitor(sb, isInterface){
            String genericName;

            @Override
            public void visitFormalTypeParameter(String name) {
                this.genericName = name;
                super.visitFormalTypeParameter(name);
            }

            @Override
            public void visitClassType(String name) {
                if (this.genericName != null) {
                    genericsMap.put(this.genericName, 'L' + name + ';');
                    this.genericName = null;
                }
                super.visitClassType(name);
            }
        };
        sr.accept(v);
        return genericsMap;
    }
}

