/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.lang.annotation.Annotation;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.TypeInfo;
import jodd.util.StringUtil;
import jodd.util.Wildcard;

public interface MethodInfo {
    public String getDeclaration();

    public TypeInfo getReturnType();

    default public String getExceptionsAsString() {
        if (this.getExceptions() == null) {
            return null;
        }
        return StringUtil.join((Object[])this.getExceptions(), ',');
    }

    public String[] getExceptions();

    public String getSignature();

    public String getCleanSignature();

    public String getMethodName();

    public int getArgumentsCount();

    public int getArgumentOffset(int var1);

    public TypeInfo getArgument(int var1);

    public int getAllArgumentsSize();

    public int getAccessFlags();

    public String getClassname();

    public String getDescription();

    public AnnotationInfo[] getAnnotations();

    public String getDeclaredClassName();

    public boolean isTopLevelMethod();

    public ClassInfo getClassInfo();

    default public boolean isPublicMethod() {
        return (this.getAccessFlags() & 1) != 0;
    }

    default public boolean isPrivateMethod() {
        return (this.getAccessFlags() & 2) != 0;
    }

    default public boolean hasNoArguments() {
        return this.getArgumentsCount() == 0;
    }

    default public boolean hasOneArgument() {
        return this.getArgumentsCount() == 1;
    }

    default public boolean isRootMethod() {
        return "java/lang/Object".equals(this.getDeclaredClassName());
    }

    default public boolean hasNoReturnValue() {
        return this.getReturnType().getOpcode() == 'V';
    }

    default public boolean hasReturnValue() {
        return this.getReturnType().getOpcode() != 'V';
    }

    default public boolean matchMethodName(String wildcard) {
        return Wildcard.match(this.getMethodName(), wildcard);
    }

    default public boolean matchClassName(String wildcard) {
        return Wildcard.match(this.getClassname(), wildcard);
    }

    default public boolean hasAnnotation(Class<? extends Annotation> ... an) {
        AnnotationInfo[] anns = this.getAnnotations();
        if (anns == null) {
            return false;
        }
        for (Class<? extends Annotation> annotationClass : an) {
            String anName = annotationClass.getName();
            for (AnnotationInfo ann : anns) {
                if (!ann.getAnnotationClassname().equals(anName)) continue;
                return true;
            }
        }
        return false;
    }

    default public AnnotationInfo getAnnotation(Class<? extends Annotation> an) {
        AnnotationInfo[] anns = this.getAnnotations();
        if (anns == null) {
            return null;
        }
        String anName = an.getName();
        for (AnnotationInfo ann : anns) {
            if (!ann.getAnnotationClassname().equals(anName)) continue;
            return ann;
        }
        return null;
    }
}

