/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jodd.asm.AsmUtil;
import jodd.asm.TraceSignatureVisitor;
import jodd.asm6.signature.SignatureVisitor;
import jodd.buffer.FastIntBuffer;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.GenericsReader;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.TypeInfo;
import jodd.proxetta.asm.AnnotationReader;
import jodd.proxetta.asm.TypeInfoImpl;
import jodd.util.StringUtil;

public class MethodSignatureVisitor
extends TraceSignatureVisitor
implements MethodInfo {
    protected final String classname;
    protected final String methodName;
    protected final String[] exceptionsArray;
    protected final boolean isStatic;
    protected final boolean isFinal;
    protected final ClassInfo targetClassInfo;
    protected final FastIntBuffer argumentsOffset;
    protected final List<TypeInfoImpl> arguments;
    protected final int access;
    protected final String description;
    protected TypeInfo returnType;
    protected String signature;
    protected int argumentsCount;
    protected int argumentsWords;
    protected String asmMethodSignature;
    protected AnnotationInfo[] annotations;
    protected String declaredClassName;
    protected final Map<String, String> generics;
    protected final Map<String, String> declaredTypeGeneric;
    private boolean visitingArgument;
    private boolean visitingReturnType;
    private boolean visitingArray;
    private int declarationTypeOffset;

    public MethodSignatureVisitor(String methodName, int access, String classname, String description, String[] exceptions, String signature, Map<String, String> declaredTypeGenerics, ClassInfo targetClassInfo) {
        super(new StringBuilder(), (access & 0x200) != 0);
        this.isStatic = (access & 8) != 0;
        this.isFinal = (access & 0x10) != 0;
        this.methodName = methodName;
        this.access = access;
        this.classname = classname;
        this.description = description;
        this.targetClassInfo = targetClassInfo;
        this.asmMethodSignature = signature;
        this.generics = new GenericsReader().parseSignatureForGenerics(signature, this.isInterface);
        this.exceptionsArray = exceptions;
        this.declaredTypeGeneric = declaredTypeGenerics;
        this.arguments = new ArrayList<TypeInfoImpl>();
        this.arguments.add(new TypeInfoImpl('L', null, null, null));
        this.argumentsOffset = new FastIntBuffer();
        this.argumentsOffset.append(0);
        this.annotations = AnnotationReader.NO_ANNOTATIONS;
    }

    @Override
    public String getSignature() {
        if (this.signature == null) {
            String decl = this.getDeclaration();
            int ndx = decl.indexOf(41);
            String retType = decl.substring(++ndx);
            StringBuilder methodDeclaration = new StringBuilder(50);
            methodDeclaration.append(retType).append(' ').append(this.methodName).append(decl, 0, ndx);
            String exceptionsAsString = this.getExceptionsAsString();
            if (exceptionsAsString != null) {
                methodDeclaration.append(" throws ").append(exceptionsAsString);
            }
            this.signature = methodDeclaration.toString();
        }
        return this.signature;
    }

    @Override
    public String getCleanSignature() {
        return this.methodName + '#' + this.getDescription();
    }

    public String getAsmMethodSignature() {
        return this.asmMethodSignature;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public int getArgumentsCount() {
        return this.argumentsCount;
    }

    @Override
    public TypeInfoImpl getArgument(int ndx) {
        return this.arguments.get(ndx);
    }

    @Override
    public int getArgumentOffset(int index) {
        return this.argumentsOffset.get(index);
    }

    @Override
    public int getAllArgumentsSize() {
        return this.argumentsWords;
    }

    @Override
    public TypeInfo getReturnType() {
        return this.returnType;
    }

    @Override
    public int getAccessFlags() {
        return this.access;
    }

    @Override
    public String getClassname() {
        return this.classname;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public AnnotationInfo[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getDeclaredClassName() {
        if (this.declaredClassName == null) {
            return this.classname;
        }
        return this.declaredClassName;
    }

    public void setDeclaredClassName(String declaredClassName) {
        this.declaredClassName = declaredClassName;
    }

    @Override
    public boolean isTopLevelMethod() {
        return this.declaredClassName == null;
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.targetClassInfo;
    }

    @Override
    public String[] getExceptions() {
        return this.exceptionsArray;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        super.visitParameterType();
        this.visitingArgument = true;
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        super.visitReturnType();
        this.visitingReturnType = true;
        return this;
    }

    @Override
    public SignatureVisitor visitArrayType() {
        this.visitingArray = true;
        return super.visitArrayType();
    }

    @Override
    public void visitBaseType(char descriptor) {
        if (this.isTopLevelType()) {
            this.declarationTypeOffset = this.declaration.length();
        }
        super.visitBaseType(descriptor);
    }

    @Override
    public void visitClassType(String name) {
        if (this.isTopLevelType()) {
            this.declarationTypeOffset = this.declaration.length();
        }
        super.visitClassType(name);
    }

    @Override
    protected void startType() {
        super.startType();
        if (this.isTopLevelType()) {
            this.declarationTypeOffset = this.declaration.length();
        }
    }

    @Override
    protected void endType() {
        super.endType();
        String type = this.declaration.subSequence(this.declarationTypeOffset, this.declaration.length()).toString();
        this.maybeUseType(type);
    }

    private void maybeUseType(String typeName) {
        String bytecodeName;
        char type;
        if (!this.isTopLevelType()) {
            return;
        }
        if (this.visitingArray) {
            type = '[';
            int arrayCount = StringUtil.count(typeName, '[');
            String arrayDepth = StringUtil.repeat('[', arrayCount);
            int ndx = typeName.indexOf(91);
            bytecodeName = typeName.substring(0, ndx);
            char arrayType = AsmUtil.typeNameToOpcode(bytecodeName);
            bytecodeName = arrayType != 'L' ? String.valueOf(arrayType) : this.resolveBytecodeName(bytecodeName);
            bytecodeName = arrayDepth + bytecodeName;
        } else {
            type = AsmUtil.typeNameToOpcode(typeName);
            bytecodeName = type != 'L' ? String.valueOf(type) : this.resolveBytecodeName(typeName);
        }
        TypeInfoImpl typeInfo = new TypeInfoImpl(type, typeName, bytecodeName, this.resolveRawTypeName(bytecodeName));
        if (this.visitingArgument) {
            if (type == 'V') {
                throw new ProxettaException("Method argument can't be void");
            }
            this.arguments.add(typeInfo);
            ++this.argumentsCount;
            this.argumentsOffset.append(this.argumentsWords + 1);
            this.argumentsWords = type == 'D' || type == 'J' ? (this.argumentsWords += 2) : ++this.argumentsWords;
        } else if (this.visitingReturnType) {
            this.returnType = typeInfo;
        }
        this.visitingReturnType = false;
        this.visitingArgument = false;
        this.visitingArray = false;
    }

    private boolean isTopLevelType() {
        return this.argumentStack == 0;
    }

    private String resolveBytecodeName(String typeName) {
        int ndx = 0;
        int genericsStartNdx = -1;
        int bracketCount = 0;
        while (ndx < typeName.length()) {
            char c = typeName.charAt(ndx);
            if (c == '<') {
                if (bracketCount == 0) {
                    genericsStartNdx = ndx;
                }
                ++bracketCount;
                ++ndx;
                continue;
            }
            if (c == '>' && --bracketCount == 0) break;
            ++ndx;
        }
        if (genericsStartNdx != -1) {
            typeName = typeName.substring(0, genericsStartNdx) + typeName.substring(ndx + 1);
        }
        if (this.isGenericType(typeName)) {
            return typeName;
        }
        return 'L' + typeName.replace('.', '/') + ';';
    }

    private String resolveRawTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        boolean isArray = typeName.startsWith("[");
        if (isArray) {
            typeName = typeName.substring(1);
        }
        String rawTypeName = this.generics.containsKey(typeName) ? this.generics.get(typeName) : this.declaredTypeGeneric.getOrDefault(typeName, typeName);
        if (isArray) {
            rawTypeName = '[' + rawTypeName;
        }
        return rawTypeName;
    }

    private boolean isGenericType(String typeName) {
        if (this.generics.containsKey(typeName)) {
            return true;
        }
        return this.declaredTypeGeneric.containsKey(typeName);
    }

    public String toString() {
        return this.getDeclaredClassName() + '#' + this.getMethodName() + this.getDescription();
    }
}

